//=============================================================================
// VisuStella MZ - Extended Message Functionality
// VisuMZ_2_ExtMessageFunc.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_2_ExtMessageFunc = true;

var VisuMZ = VisuMZ || {};
VisuMZ.ExtMessageFunc = VisuMZ.ExtMessageFunc || {};
VisuMZ.ExtMessageFunc.version = 1.20;

//=============================================================================
 /*:
 * @target MZ
 * @plugindesc [RPG Maker MZ] [Tier 2] [Version 1.20] [ExtMessageFunc]
 * @author VisuStella
 * @url http://www.yanfly.moe/wiki/Extended_Message_Functionality_VisuStella_MZ
 * @base VisuMZ_1_MessageCore
 * @orderAfter VisuMZ_1_MessageCore
 *
 * @help
 * ============================================================================
 * Introduction
 * ============================================================================
 *
 * The Extended Message Function plugin adds onto RPG Maker MZ's Message Window
 * and adds in various features you would normally see found in modern RPG's.
 * Things like automatically moving the text forward after a set amount of time
 * or fast forward are available. Saving and loading during a message is also
 * possible as well as going to the Options menu or returning back to the title
 * screen. These options are only available to the Message Window on the map
 * scene and do not work in battle.
 *
 * Features include all (but not limited to) the following:
 * 
 * * The Button Console appears on the Message Window let the player activate
 *   various commands via touch/click.
 * * Extended Fast Forward Mode is an expanded feature upon the Message Core's
 *   Fast Forward function to fast forward all events and not just messages.
 *   This can be optionally disabled.
 * * A Message Cursor will appear where the text has ended for those who want
 *   that kind of aesthetic in their game.
 * * Auto-Forward will automatically move messages onward after a certain
 *   amount of time has passed. Time required will be determined based on the
 *   length of the message in question.
 * * Saving and Loading can be done from the Message Window akin to how many
 *   visual novels work. Requires the Save Core, but you're already using that,
 *   right? Right?
 * * Also be able to jump straight into the Options scene from the Message
 *   Window to change any settings on the fly. Requires the Options Core, but
 *   you're using that, too, correct?
 * * And for those who want to jump back to the title screen, they can do so
 *   by selecting a Game End option, too.
 *
 * ============================================================================
 * Requirements
 * ============================================================================
 *
 * This plugin is made for RPG Maker MZ. This will not work in other iterations
 * of RPG Maker.
 *
 * ------ Required Plugin List ------
 *
 * * VisuMZ_1_MessageCore
 *
 * This plugin requires the above listed plugins to be installed inside your
 * game's Plugin Manager list in order to work. You cannot start your game with
 * this plugin enabled without the listed plugins.
 *
 * ------ Tier 2 ------
 *
 * This plugin is a Tier 2 plugin. Place it under other plugins of lower tier
 * value on your Plugin Manager list (ie: 0, 1, 2, 3, 4, 5). This is to ensure
 * that your plugins will have the best compatibility with the rest of the
 * VisuStella MZ library.
 *
 * ============================================================================
 * Extra Features
 * ============================================================================
 *
 * There are some extra features found if other VisuStella MZ plugins are found
 * present in the Plugin Manager list.
 *
 * ---
 *
 * VisuMZ_1_OptionsCore
 *
 * The Options Core is a required plugin in order to make use of the "Options"
 * (aka "Config") button found in the Button Console.
 *
 * ---
 *
 * VisuMZ_1_SaveCore
 *
 * The Options Core is a required plugin in order to make use of the "Save" and
 * "Load" buttons found in the Button Console.
 *
 * ---
 * 
 * VisuMZ_3_MessageLog
 * 
 * The Message Log plugin enables the "Log" button found in the Button Console
 * to let the player go and review the text that has been displayed in the map
 * scene. This does not include the text found in battle to avoid conflicting
 * logged messages across different situations.
 * 
 * ---
 * 
 * VisuMZ_4_MessageVisibility
 * 
 * The Message Visibility plugin enables the "Hide" button found in the
 * Button Console to make the Message Window visible or invisible.
 * 
 * ---
 *
 * ============================================================================
 * Available Text Codes
 * ============================================================================
 *
 * The following are text codes that you may use with this plugin. 
 *
 * === Button Console-Related Text Codes ===
 * 
 * ---
 *
 * --------------------   -----------------------------------------------------
 * Text Code              Effect (Message Window Only)
 * --------------------   -----------------------------------------------------
 * 
 * <Hide Buttons>         Hides the Button Console from this current Message
 *                        Window's text assuming that nothing else is hiding
 *                        the Button Console from view.
 * 
 * ---
 * 
 * === Message Tail-Related Text Codes ===
 *
 * --------------------   -----------------------------------------------------
 * Text Code              Effect (Message Window Only)
 * --------------------   -----------------------------------------------------
 * 
 * <Tail Bottom Left: x>  Creates a message tail at x coordinate pointing to
 *                        the bottom left.
 * <Tail Bottom Right: x> Creates a message tail at x coordinate pointing to
 *                        the bottom right.
 * <Tail Upper Left: x>   Creates a message tail at x coordinate pointing to
 *                        the upper left.
 * <Tail Upper Right: x>  Creates a message tail at x coordinate pointing to
 *                        the upper right.
 * 
 * ---
 *
 * ============================================================================
 * Plugin Commands
 * ============================================================================
 *
 * The following are Plugin Commands that come with this plugin. They can be
 * accessed through the Plugin Command event command.
 *
 * ---
 * 
 * === Fast Forward Plugin Commands ===
 * 
 * ---
 *
 * Fast Forward: Allow/Disallow
 * - Change whether or not Fast Forward is allowed/disallowed.
 * - Must be enabled by the Plugin Parameters.
 *
 *   Allow?:
 *   - Allow or disallow the Extended Fast Forward feature?
 *   - Must be enabled by the Plugin Parameters.
 *
 * ---
 * 
 * === Message Button Console Plugin Commands ===
 * 
 * ---
 *
 * Message Button Console: Show/Hide
 * - Determine if the Message Button Console is visible or hidden.
 * - Only appears on the map. 
 * - Does not appear in battle.
 *
 *   Visible?:
 *   - Show or hide the Message Button Console feature?
 *   - Only appears on the map.
 *   - Does not appear in battle.
 *
 * ---
 * 
 * === Message Cursor Plugin Commands ===
 * 
 * ---
 *
 * Message Cursor: Change Settings
 * - Change the Message Cursor settings used.
 *
 *   Change Settings:
 *   - Change the Message Cursor settings.
 *   - Settings are the same as the ones found in the Plugin Parameters.
 *
 * ---
 * 
 * === Message Tail Plugin Commands ===
 * 
 * ---
 * 
 * Message Tail: Change Settings
 * - Change the Message Tail settings.
 * 
 *   Message Tail Settings:
 *   - Message Tail settings used for Message Windows.
 *   - Requires images and text codes to appear.
 *   - See Plugin Parameters. They have the same parameters.
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Auto-Forward Settings
 * ============================================================================
 *
 * Auto-Forward settings used for this game. Auto-Forward is a feature that
 * once enabled, the game will automatically move the "Show Text" event
 * commands forward after a certain amount of time. The amount of time will be
 * determined by how many characters are displayed on the screen. There is a
 * lower boundary, where if the wait time does not meet the amount, the timer
 * will be set to the minimum wait value instead.
 *
 * ---
 *
 * Settings
 * 
 *   Wait per Character:
 *   - How many frames should the game wait per character?
 *   - Average: 60 frames per second.
 * 
 *   Minimum Wait:
 *   - What is the minimum amount of frames to wait?
 *   - Average: 60 frames per second.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Fast Forward (Extended) Settings
 * ============================================================================
 *
 * Extended Fast Forward settings used for this game. If enabled, this will
 * replace the Message Core's Fast Forward functionality. The Extended Fast
 * Forward feature will not only fast forward through messages but any running
 * events that are not found in a parallel event.
 * 
 * It can also be activated the Message Core's Fast Forward shortcut key.
 *
 * ---
 *
 * Settings
 * 
 *   Enable?:
 *   - Enable or disable the Extended Fast Forward feature?
 * 
 *   Speed:
 *   - What is the speed at which Extended Fast Forward works at?
 *   - Higher numbers are faster.
 * 
 *   Reset on Scene Change?:
 *   - Reset Fast Forward setting on scene changes (ie battle, menu, or
 *     map transfers)?
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Message Button Console Settings
 * ============================================================================
 *
 * Message Button Console settings used for this game.
 * 
 * It will only appear in the Message Window on the map scene. It will NOT
 * appear in battle. The reason it won't appear in battle is because many of
 * the functions there will clash with how the battle scene behaves.
 * 
 * The Button Console will add extra padding to the Message Window and appear
 * at either the top of bottom of the Message Window (your choice). A row of
 * buttons will appear each with a different functionality.
 * 
 * These Plugin Parameters also allow you to customize the appearance of how
 * the buttons look in-game. Adjust them accordingly.
 *
 * ---
 *
 * General
 * 
 *   Show by Default?:
 *   - Show or hide the Message Button Console by default?
 * 
 *   Position:
 *   - Where do you wish to display the Message Button Console?
 *     - Top of Message Window
 *     - Bottom of Message Window
 * 
 *   Auto-Size Hide?:
 *   - Hide the button console when using auto-size text codes?
 *
 * ---
 *
 * Appearance
 * 
 *   Window Skin:
 *   - What is the window skin used for the buttons?
 *   - Ignore if using Background Images.
 * 
 *   Font Name:
 *   - What font do you wish to use for the Message Button Console?
 * 
 *     Font Size:
 *     - What font size do you wish to use for the Message Button Console?
 * 
 *   Text Colors:
 * 
 *     Normal Color:
 *     - Use #rrggbb for custom colors or regular numbers for text colors from
 *       the Window Skin.
 * 
 *     Toggled Color:
 *     - Use #rrggbb for custom colors or regular numbers for text colors from
 *       the Window Skin.
 * 
 *     Disabled Color:
 *     - Use #rrggbb for custom colors or regular numbers for text colors from
 *       the Window Skin.
 * 
 *   Visuals:
 * 
 *     Offset X:
 *     - Offsets the buttons x position.
 *     - Negative: left. Positive: right.
 * 
 *     Offset Y:
 *     - Offsets the buttons y position.
 *     - Negative: up. Positive: down.
 * 
 *     Width:
 *     - What is the width of each button?
 * 
 *     Height:
 *     - What is the height of each button?
 * 
 *     Buffer:
 *     - What is the buffer between each button?
 * 
 *   Background Images:
 * 
 *     Disabled Image:
 *     Enabled Image:
 *     Toggled Image:
 *     - Filename of the background image when the button is disabled,
 *       enabled, or toggled.
 *     - This will hide the window skin for this button.
 * 
 *     Offset X:
 *     - Offsets the X position of this image.
 *     - Negative: left; Positive: right
 * 
 *     Offset Y:
 *     - Offsets the Y position of this image.
 *     - Negative: up; Positive: down
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Button Settings
 * ============================================================================
 *
 * Settings for which buttons appear and how they appear. These settings will
 * determine which buttons appear (provided that their required plugins are
 * available), what shortcut keys are applied to them, and what kind of text
 * will be displayed to represent them.
 * 
 * In case you are wondering where the Fast Forward shortcut key is, that
 * setting is found in the Message Core.
 *
 * ---
 *
 * General
 * 
 *   List:
 *   - Which buttons appear and in what order?
 *   - Some commands require certain plugins installed.
 *
 * ---
 *
 * Shortcut Keys
 * 
 *   Auto-Forward Key:
 *   - This is the key used for auto-forwarding messages.
 * 
 *   Save Key:
 *   - This is the key used for quick saving.
 *   - Requires VisuMZ_1_SaveCore!
 * 
 *   Load Key:
 *   - This is the key used for quick load.
 *   - Requires VisuMZ_1_SaveCore!
 * 
 *   Options Key:
 *   - This is the key used for opening options.
 *   - Requires VisuMZ_1_OptionsCore!
 * 
 *   Game End Key:
 *   - This is the key used for ending the game.
 *
 * ---
 *
 * Vocabulary
 * 
 *   Auto-Forward:
 *   - How is this option's text displayed in-game?
 * 
 *   Fast Forward:
 *   - How is this option's text displayed in-game?
 * 
 *   Save Game:
 *   - How is this option's text displayed in-game?
 *   - Requires VisuMZ_1_SaveCore!
 * 
 *   Load Game:
 *   - How is this option's text displayed in-game?
 *   - Requires VisuMZ_1_SaveCore!
 * 
 *   Options:
 *   - How is this option's text displayed in-game?
 *   - Requires VisuMZ_1_OptionsCore!
 * 
 *   Game End:
 *   - How is this option's text displayed in-game?
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Message Cursor Settings
 * ============================================================================
 *
 * Message Cursor settings used for this game. The cursor, if enabled, will
 * appear where the text is currently displayed at and adds a new type of
 * aesthetic to the game.
 *
 * ---
 *
 * General
 * 
 *   Enable?:
 *   - Enable or disable the message cursor?
 * 
 *   Graphic Type:
 *   - What is the cursor's graphic type?
 *     - Icon - From img/system/IconSet.png
 *     - Image - An animated image from img/system/
 *     - Window Skin - Use the default Window Skin cursor
 *
 * ---
 *
 * Icon
 * 
 *   Icon Index:
 *   - This is icon used for the Message Cursor.
 * 
 *   Flip Speed Multiplier:
 *   - What is the flip speed multiplier for the Message Cursor?
 *   - Use 0 for no flipping.
 *
 * ---
 *
 * Image
 * 
 *   Filename:
 *   - Filename of the image found inside the img/system/ folder.
 * 
 *   Image Rows:
 *   - How many rows are there for the image?
 * 
 *   Image Columns:
 *   - How many columns are there for the image?
 * 
 *   Frame Delay:
 *   - How many frames delayed are there per animated cell?
 *
 * ---
 *
 * Appearance
 * 
 *   Anchor X:
 *   Anchor Y:
 *   - Determine the Message Cursor's X/Y position.
 *   - Use a number between 0 and 1 for best results.
 * 
 *   Offset X:
 *   Offset Y:
 *   - Offset the Message Cursor's X/Y position by how many pixels?
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Message Tail Settings
 * ============================================================================
 *
 * Message Tails can be made to appear from the Message Window and point
 * towards the speaker, similar to how speech bubbles in comics point towards
 * their speakers. The Message Tails do not appear on their own, and only come
 * out when using auto-position text codes (if enabled) such as <Auto Player>
 * or when text codes are used to make them appear such as <Tail Upper Left: x>
 * and <Tail Lower Right: x>.
 * 
 * These settings require custom graphics that this plugin does not come with.
 * You will need to add them on your own or else they will not appear.
 *
 * ---
 *
 * Auto-Position
 * 
 *   Enable?:
 *   - Show Message Tails with Auto-Position text codes?
 *   - Message Tails will appear when using the following text codes:
 *     - <Auto Actor: x>
 *     - <Auto Party: x>
 *     - <Auto Player>
 *     - <Auto Event: x>
 *     - <Auto Enemy: x>
 * 
 *   Face Left?:
 *   - Which direction does the Message Tail point to?
 *   - Left or right?
 * 
 *   Auto-Correct X:
 *   - Auto-corrects Message Tail position X when used with Auto-Position but
 *     are too close to edge of screen.
 * 
 *   Offset X:
 *   Offset Y:
 *   - Message Window's X offset with auto-position.
 *   - X: Negative: left. Positive: right.
 *   - Y: Negative: up. Positive: down.
 *
 * ---
 *
 * Tail Directions
 * Tail Directions > Bottom Left
 * Tail Directions > Bottom Right
 * Tail Directions > Upper Left
 * Tail Directions > Upper Right
 * 
 *   Filename:
 *   - Filename of the Message Tail graphic going towards the
 *     specified direction.
 * 
 *   Anchor X:
 *   - Anchor value X. Use a number between 0 and 1.
 *   - 0.0 - Left; 0.5 - Center; 1.0 - Right
 * 
 *   Anchor Y:
 *   - Anchor value Y. Use a number between 0 and 1.
 *   - 0.0 - Top; 0.5 - Middle; 1.0 - Bottom
 * 
 *   Offset X:
 *   - Offset the Message Tail's X position.
 *   - Negative: left. Positive: right.
 * 
 *   Offset Y:
 *   - Offset the Message Tail's Y position.
 *   - Negative: left. Positive: right.
 *
 * ---
 *
 * ============================================================================
 * Terms of Use
 * ============================================================================
 *
 * 1. These plugins may be used in free or commercial games provided that they
 * have been acquired through legitimate means at VisuStella.com and/or any
 * other official approved VisuStella sources. Exceptions and special
 * circumstances that may prohibit usage will be listed on VisuStella.com.
 * 
 * 2. All of the listed coders found in the Credits section of this plugin must
 * be given credit in your games or credited as a collective under the name:
 * "VisuStella".
 * 
 * 3. You may edit the source code to suit your needs, so long as you do not
 * claim the source code belongs to you. VisuStella also does not take
 * responsibility for the plugin if any changes have been made to the plugin's
 * code, nor does VisuStella take responsibility for user-provided custom code
 * used for custom control effects including advanced JavaScript notetags
 * and/or plugin parameters that allow custom JavaScript code.
 * 
 * 4. You may NOT redistribute these plugins nor take code from this plugin to
 * use as your own. These plugins and their code are only to be downloaded from
 * VisuStella.com and other official/approved VisuStella sources. A list of
 * official/approved sources can also be found on VisuStella.com.
 *
 * 5. VisuStella is not responsible for problems found in your game due to
 * unintended usage, incompatibility problems with plugins outside of the
 * VisuStella MZ library, plugin versions that aren't up to date, nor
 * responsible for the proper working of compatibility patches made by any
 * third parties. VisuStella is not responsible for errors caused by any
 * user-provided custom code used for custom control effects including advanced
 * JavaScript notetags and/or plugin parameters that allow JavaScript code.
 *
 * 6. If a compatibility patch needs to be made through a third party that is
 * unaffiliated with VisuStella that involves using code from the VisuStella MZ
 * library, contact must be made with a member from VisuStella and have it
 * approved. The patch would be placed on VisuStella.com as a free download
 * to the public. Such patches cannot be sold for monetary gain, including
 * commissions, crowdfunding, and/or donations.
 * 
 * 7. If this VisuStella MZ plugin is a paid product, all project team members
 * must purchase their own individual copies of the paid product if they are to
 * use it. Usage includes working on related game mechanics, managing related
 * code, and/or using related Plugin Commands and features. Redistribution of
 * the plugin and/or its code to other members of the team is NOT allowed
 * unless they own the plugin itself as that conflicts with Article 4.
 * 
 * 8. Any extensions and/or addendums made to this plugin's Terms of Use can be
 * found on VisuStella.com and must be followed.
 *
 * ============================================================================
 * Credits
 * ============================================================================
 * 
 * If you are using this plugin, credit the following people in your game:
 * 
 * Team VisuStella
 * * Irina
 * * Arisu
 * * Olivia
 * * Yanfly
 *
 * ============================================================================
 * Changelog
 * ============================================================================
 * 
 * Version 1.20: April 17, 2025
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameters added by Arisu:
 * *** Parameters > Message Tails > Auto-Position > Auto-Correct X
 * **** Auto-corrects Message Tail position X when used with Auto-Position but
 *      are too close to edge of screen.
 * 
 * Version 1.19: February 20, 2025
 * * Compatibility Update!
 * ** Updated for RPG Maker MZ Core Scripts 1.9.0!
 * *** Better compatibility with different face sizes.
 * 
 * Version 1.18: December 19, 2024
 * * Bug Fixes!
 * ** Fixed a bug where if the button console was top positioned and the
 *    buttons were hidden, the rest of the text would not readjust. Fix made
 *    by Irina.
 * 
 * Version 1.17: June 13, 2024
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameters added by Irina:
 * *** Parameters > Message Button Console > Button Visuals > Offset X
 * *** Parameters > Message Button Console > Button Visuals > Offset Y
 * **** Adjusts the X/Y position of the buttons.
 * 
 * Version 1.16: March 14, 2024
 * * Bug Fixes!
 * ** Fixed a text positioning issue with the message window when shown in
 *    battle and a top-aligned button console. Fix made by Irina.
 * 
 * Version 1.15: December 14, 2023
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * 
 * Version 1.14: May 18, 2023
 * * Bug Fixes!
 * ** Fixed a bug that made hidden buttons via <Hide Button Console> still able
 *    to be pressed. Fix made by Irina.
 * 
 * Version 1.13: February 16, 2023
 * * Bug Fixes!
 * ** Fixed a bug that prevents <Hide Button Console> from working when word
 *    wrap is enabled. Fix made by Irina.
 * 
 * Version 1.12: December 15, 2022
 * * Bug Fixes!
 * ** Fixed a bug where the menu background settings from VisuMZ Core Engine
 *    did not carry over to the save menu when accessing it through the Message
 *    Button Console. Fix made by Olivia.
 * 
 * Version 1.11: November 10, 2022
 * * Bug Fixes!
 * ** Plugin Command "Message Cursor: Change Settings" no longer leaves behind
 *    the old cursor sprite when a new one is selected. Fix made by Irina.
 * 
 * Version 1.10: August 11, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameter added by Irina
 * *** Plugin Parameters > Fast Forward > Reset on Scene Change?
 * **** Reset Fast Forward setting on scene changes (ie battle, menu, or
 *      map transfers)?
 * 
 * Version 1.09: April 7, 2022
 * * Bug Fixes!
 * ** Default message cursor no longer appears in the wrong place when no
 *    message cursor skin is used for auto-sized messages. Fix by Arisu.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameter option added by Arisu and sponsored by Archeia:
 * *** Plugin Parameters > Message Cursor Settings > Graphics Type
 * **** New option added: Window Skin - Use the default Window Skin cursor
 * **** This is for those who wish to use the default window skin cursor
 *      instead of icons or images.
 * 
 * Version 1.08: March 17, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Commands, Text Codes, and Plugin Parameters added by Irina
 *    and sponsored by Archeia!
 * *** Message Tails can be made to appear from the Message Window and point
 *     towards the speaker, similar to how speech bubbles in comics point
 *     towards their speakers. The Message Tails do not appear on their own,
 *     and only come out when using auto-position text codes (if enabled) such
 *     as <Auto Player> or when text codes are used to make them appear such as
 *     <Tail Upper Left: x> and <Tail Lower Right: x>.
 * *** These settings require custom graphics that this plugin does not come
 *     with. You will need to add them on your own or else they will not
 *     appear.
 * *** Text Codes added: <Tail Bottom Left: x>, <Tail Bottom Right: x>,
 *     <Tail Upper Left: x>, <Tail Upper Right: x>
 * *** Plugin Command Added: Message Tail: Change Settings
 * *** Plugin Parameters Added: Message Tail Settings
 * 
 * Version 1.07: March 3, 2022
 * * Compatibility Update
 * ** Added better compatibility functionality with other plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameter added by Irina and sponsored by AndyL:
 * *** Plugin Parameters > Message Button Console > Auto-Size Hide?
 * **** Hide the button console when using auto-size text codes?
 * 
 * Version 1.06: November 18, 2021
 * * Compatibility Update
 * ** Added compatibility functionality for future plugins.
 * 
 * Version 1.05: November 4, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameters added by Irina and sponsored by Archeia:
 * *** Plugin Parameters > Message Button Console > Background Images
 * **** Adds a background image to this button instead of using a window skin.
 * **** This will disable the window skin.
 * **** Various images can be used for "Disabled", "Enabled", and "Toggled".
 * **** Offset X and Y positions.
 * 
 * Version 1.04: October 14, 2021
 * * Feature Update!
 * ** Added an alert requirement for those who are using very old versions of
 *    the Message Core that cannot sustain the requirements of this plugin.
 *    Added by Irina.
 * 
 * Version 1.03: September 3, 2021
 * * Bug Fixes!
 * ** Pause sprite, for the Message Window, will no longer show multiple copies
 *    if the message cursor sprite is disabled. Fix made by Irina.
 * 
 * Version 1.02: August 6, 2021
 * * Documentation Update!
 * ** Plugin URL now updated to most recent one.
 * 
 * Version 1.01: July 30, 2021
 * * Feature Update!
 * ** Added graphic pre-loading for save/load menu preparation. Added by Irina.
 * 
 * Version 1.00 Official Release Date: August 2, 2021
 * * Finished Plugin!
 *
 * ============================================================================
 * End of Helpfile
 * ============================================================================
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ExtFastFwdDisallow
 * @text Fast Forward: Allow/Disallow
 * @desc Change whether or not Fast Forward is allowed/disallowed.
 * Must be enabled by the Plugin Parameters.
 *
 * @arg Allow:eval
 * @text Allow?
 * @parent General
 * @type boolean
 * @on Allow
 * @off Disallow
 * @desc Allow or disallow the Extended Fast Forward feature?
 * Must be enabled by the Plugin Parameters.
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command MsgButtonConsole
 * @text Message Button Console: Show/Hide
 * @desc Determine if the Message Button Console is visible or hidden.
 * Only appears on the map. Does not appear in battle.
 *
 * @arg Visible:eval
 * @text Visible?
 * @parent General
 * @type boolean
 * @on Visible
 * @off Hidden
 * @desc Show or hide the Message Button Console feature?
 * Only appears on the map. Does not appear in battle.
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command MessageCursorSettings
 * @text Message Cursor: Change Settings
 * @desc Change the Message Cursor settings used.
 *
 * @arg MsgCursor:struct
 * @text Change Settings
 * @type struct<MsgCursor>
 * @desc Change the Message Cursor settings.
 * @default {"General":"","Enable:eval":"true","GraphicType:str":"icon","Icon":"","IconIndex:str":"188","FlipMultiplier:str":"0.125","Image":"","Filename:str":"","Rows:num":"1","Cols:num":"1","FrameDelay:num":"4","Appearance":"","AnchorX:num":"0.5","AnchorY:num":"1","OffsetX:num":"+0","OffsetY:num":"-4"}
 *
 * @ --------------------------------------------------------------------------
 * 
 * @command MessageTailSettings
 * @text Message Tail: Change Settings
 * @desc Change the Message Tail settings.
 *
 * @arg Settings:struct
 * @text Message Tail Settings
 * @type struct<MsgTail>
 * @desc Message Tail settings used for Message Windows.
 * Requires images and text codes to appear.
 * @default {"AutoPosition":"","autoPositionTail:eval":"true","autoPositionLeft:eval":"true","autoPositionOffsetX:num":"+0","autoPositionOffsetY:num":"+0","TailDir":"","BottomLeft":"","bottomLeftFilename:str":"","bottomLeftAnchorX:num":"0.5","bottomLeftAnchorY:num":"0.0","bottomLeftOffsetX:num":"+0","bottomLeftOffsetY:num":"+0","BottomRight":"","bottomRightFilename:str":"","bottomRightAnchorX:num":"0.5","bottomRightAnchorY:num":"0.0","bottomRightOffsetX:num":"+0","bottomRightOffsetY:num":"+0","UpperLeft":"","upperLeftFilename:str":"","upperLeftAnchorX:num":"0.5","upperLeftAnchorY:num":"1.0","upperLeftOffsetX:num":"+0","upperLeftOffsetY:num":"+0","UpperRight":"","upperRightFilename:str":"","upperRightAnchorX:num":"0.5","upperRightAnchorY:num":"1.0","upperRightOffsetX:num":"+0","upperRightOffsetY:num":"+0"}
 * 
 * @ --------------------------------------------------------------------------
 *
 * @ ==========================================================================
 * @ Plugin Parameters
 * @ ==========================================================================
 *
 * @param BreakHead
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param ExtMessageFunc
 * @default Plugin Parameters
 *
 * @param ATTENTION
 * @default READ THE HELP FILE
 *
 * @param BreakSettings
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param Auto:struct
 * @text Auto-Forward Settings
 * @type struct<Auto>
 * @desc Auto-Forward settings used for this game.
 * @default {"WaitPerChar:num":"6","MinimumWait:num":"300"}
 *
 * @param FastFwd:struct
 * @text Fast Forward (Extended)
 * @type struct<FastFwd>
 * @desc Extended Fast Forward settings used for this game.
 * @default {"Enable:eval":"true","Speed:num":"8","SceneChangeReset:eval":"true"}
 *
 * @param MsgButtonConsole:struct
 * @text Message Button Console
 * @type struct<MsgButtonConsole>
 * @desc Message Button Console settings used for this game.
 * @default {"General":"","ShowDefault:eval":"true","Position:str":"bottom","Appearance":"","WindowSkin:str":"Window","FontFace:str":"Arial","FontSize:num":"18","TextColors":"","NormalColor:str":"0","ToggledColor:str":"24","DisabledColor:str":"7","Visuals":"","ButtonWidth:num":"86","ButtonHeight:num":"36","ButtonBuffer:num":"6"}
 *
 * @param Buttons:struct
 * @text Button Settings
 * @parent MsgButtonConsole:struct
 * @type struct<Buttons>
 * @desc Settings for which buttons appear and how they appear.
 * @default {"General":"","List:arraystr":"[\"auto\",\"fastFwd\",\"log\",\"hide\",\"save\",\"load\",\"options\",\"gameEnd\"]","AutoKey:str":"none","Shortcuts":"","SaveKey:str":"none","LoadKey:str":"none","OptionsKey:str":"none","GameEndKey:str":"none","Vocab":"","Auto:str":"AUTO","FastFwd:str":"FAST","Save:str":"SAVE","Load:str":"LOAD","Options:str":"CONFIG","GameEnd:str":"TITLE"}
 *
 * @param MsgCursor:struct
 * @text Message Cursor Settings
 * @type struct<MsgCursor>
 * @desc Message Cursor settings used for this game.
 * @default {"General":"","Enable:eval":"true","GraphicType:str":"icon","Icon":"","IconIndex:str":"188","FlipMultiplier:str":"0.125","Image":"","Filename:str":"","Rows:num":"1","Cols:num":"1","FrameDelay:num":"4","Appearance":"","AnchorX:num":"0.5","AnchorY:num":"1","OffsetX:num":"+0","OffsetY:num":"-4"}
 *
 * @param MsgTail:struct
 * @text Message Tail Settings
 * @type struct<MsgTail>
 * @desc Message Tail settings used for Message Windows.
 * Requires images and text codes to appear.
 * @default {"AutoPosition":"","autoPositionTail:eval":"true","autoPositionLeft:eval":"true","autoPositionOffsetX:num":"+0","autoPositionOffsetY:num":"+0","TailDir":"","BottomLeft":"","bottomLeftFilename:str":"","bottomLeftAnchorX:num":"0.5","bottomLeftAnchorY:num":"0.0","bottomLeftOffsetX:num":"+0","bottomLeftOffsetY:num":"+0","BottomRight":"","bottomRightFilename:str":"","bottomRightAnchorX:num":"0.5","bottomRightAnchorY:num":"0.0","bottomRightOffsetX:num":"+0","bottomRightOffsetY:num":"+0","UpperLeft":"","upperLeftFilename:str":"","upperLeftAnchorX:num":"0.5","upperLeftAnchorY:num":"1.0","upperLeftOffsetX:num":"+0","upperLeftOffsetY:num":"+0","UpperRight":"","upperRightFilename:str":"","upperRightAnchorX:num":"0.5","upperRightAnchorY:num":"1.0","upperRightOffsetX:num":"+0","upperRightOffsetY:num":"+0"}
 *
 * @param BreakEnd1
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param End Of
 * @default Plugin Parameters
 *
 * @param BreakEnd2
 * @text --------------------------
 * @default ----------------------------------
 *
 */
/* ----------------------------------------------------------------------------
 * Auto-Forward Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Auto:
 *
 * @param WaitPerChar:num
 * @text Wait per Character
 * @parent General
 * @type number
 * @min 1
 * @desc How many frames should the game wait per character?
 * Average: 60 frames per second.
 * @default 6
 *
 * @param MinimumWait:num
 * @text Minimum Wait
 * @parent General
 * @type number
 * @min 1
 * @desc What is the minimum amount of frames to wait?
 * Average: 60 frames per second.
 * @default 300
 *
 */
/* ----------------------------------------------------------------------------
 * Extended Fast Forward Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~FastFwd:
 *
 * @param Enable:eval
 * @text Enable?
 * @parent General
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Enable or disable the Extended Fast Forward feature?
 * @default true
 *
 * @param Speed:num
 * @text Speed
 * @parent General
 * @type number
 * @min 2
 * @desc What is the speed at which Extended Fast Forward works at?
 * Higher numbers are faster.
 * @default 8
 *
 * @param SceneChangeReset:eval
 * @text Reset on Scene Change?
 * @parent General
 * @type boolean
 * @on Reset
 * @off Keep
 * @desc Reset Fast Forward setting on scene changes (ie battle, menu, or map transfers)?
 * @default true
 *
 */
/* ----------------------------------------------------------------------------
 * Message Button Console Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~MsgButtonConsole:
 *
 * @param General
 *
 * @param ShowDefault:eval
 * @text Show by Default?
 * @parent General
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show or hide the Message Button Console by default?
 * @default true
 *
 * @param Position:str
 * @text Position
 * @parent General
 * @type select
 * @option Top of Message Window
 * @value top
 * @option Bottom of Message Window
 * @value bottom
 * @desc Where do you wish to display the Message Button Console?
 * @default bottom
 *
 * @param AutoSizeHide:eval
 * @text Auto-Size Hide?
 * @parent General
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Hide the button console when using auto-size text codes?
 * @default false
 *
 * @param Appearance
 *
 * @param WindowSkin:str
 * @text Window Skin
 * @parent Appearance
 * @type file
 * @dir img/system/
 * @require 1
 * @desc What is the window skin used for the buttons?
 * Ignore if using Background Images.
 * @default Window
 *
 * @param FontFace:str
 * @text Font Name
 * @parent Appearance
 * @desc What font do you wish to use for the Message Button Console?
 * @default Arial
 *
 * @param FontSize:num
 * @text Font Size
 * @parent FontFace:str
 * @type number
 * @min 1
 * @desc What font size do you wish to use for the Message Button Console?
 * @default 18
 * 
 * @param TextColors
 * @text Text Colors
 * @parent Appearance
 *
 * @param NormalColor:str
 * @text Normal Color
 * @parent TextColors
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 0
 *
 * @param ToggledColor:str
 * @text Toggled Color
 * @parent TextColors
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 24
 *
 * @param DisabledColor:str
 * @text Disabled Color
 * @parent TextColors
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 7
 *
 * @param Visuals
 * @text Button Visuals
 * @parent Appearance
 *
 * @param ButtonOffsetX:num
 * @text Offset X
 * @parent Visuals
 * @desc Offsets the buttons x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param ButtonOffsetY:num
 * @text Offset Y
 * @parent Visuals
 * @desc Offsets the buttons y position.
 * Negative: up. Positive: down.
 * @default +0
 *
 * @param ButtonWidth:num
 * @text Width
 * @parent Visuals
 * @type number
 * @min 1
 * @desc What is the width of each button?
 * @default 86
 *
 * @param ButtonHeight:num
 * @text Height
 * @parent Visuals
 * @type number
 * @min 1
 * @desc What is the height of each button?
 * @default 36
 *
 * @param ButtonBuffer:num
 * @text Buffer
 * @parent Visuals
 * @type number
 * @min 1
 * @desc What is the buffer between each button?
 * @default 6
 *
 * @param Images
 * @text Background Images
 * @parent Appearance
 *
 * @param ImgDisabled:str
 * @text Disabled Image
 * @parent Images
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Filename of the background image when the button is disabled.
 * @default 
 *
 * @param ImgDisabledOffsetX:num
 * @text Offset X
 * @parent ImgDisabled:str
 * @desc Offsets the X position of this image.
 * Negative: left; Positive: right
 * @default +0
 *
 * @param ImgDisabledOffsetY:num
 * @text Offset Y
 * @parent ImgDisabled:str
 * @desc Offsets the Y position of this image.
 * Negative: up; Positive: down
 * @default +0
 *
 * @param ImgEnabled:str
 * @text Enabled Image
 * @parent Images
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Filename of the background image when the button is enabled.
 * @default 
 *
 * @param ImgEnabledOffsetX:num
 * @text Offset X
 * @parent ImgEnabled:str
 * @desc Offsets the X position of this image.
 * Negative: left; Positive: right
 * @default +0
 *
 * @param ImgEnabledOffsetY:num
 * @text Offset Y
 * @parent ImgEnabled:str
 * @desc Offsets the Y position of this image.
 * Negative: up; Positive: down
 * @default +0
 *
 * @param ImgToggled:str
 * @text Toggled Image
 * @parent Images
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Filename of the background image when the button is toggled.
 * @default 
 *
 * @param ImgToggledOffsetX:num
 * @text Offset X
 * @parent ImgToggled:str
 * @desc Offsets the X position of this image.
 * Negative: left; Positive: right
 * @default +0
 *
 * @param ImgToggledOffsetY:num
 * @text Offset Y
 * @parent ImgToggled:str
 * @desc Offsets the Y position of this image.
 * Negative: up; Positive: down
 * @default +0
 *
 */
/* ----------------------------------------------------------------------------
 * Buttons Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Buttons:
 *
 * @param General
 *
 * @param List:arraystr
 * @text List
 * @parent General
 * @type combo[]
 * @option auto
 * @option log
 * @option fastFwd
 * @option gameEnd
 * @option hide
 * @option load
 * @option options
 * @option save
 * @desc Which buttons appear and in what order?
 * Some commands require certain plugins installed.
 * @default ["auto","fastFwd","log","hide","save","load","options","gameEnd"]
 * 
 * @param Shortcuts
 * @text Shortcut Keys
 *
 * @param AutoKey:str
 * @text Auto-Forward Key
 * @parent General
 * @type combo
 * @option none
 * @option tab
 * @option shift
 * @option control
 * @option pageup
 * @option pagedown
 * @desc This is the key used for auto-forwarding messages.
 * @default none
 * 
 * @param SaveKey:str
 * @text Save Key
 * @parent Shortcuts
 * @type combo
 * @option none
 * @option tab
 * @option shift
 * @option control
 * @option pageup
 * @option pagedown
 * @desc This is the key used for quick saving.
 * Requires VisuMZ_1_SaveCore!
 * @default none
 * 
 * @param LoadKey:str
 * @text Load Key
 * @parent Shortcuts
 * @type combo
 * @option none
 * @option tab
 * @option shift
 * @option control
 * @option pageup
 * @option pagedown
 * @desc This is the key used for quick load.
 * Requires VisuMZ_1_SaveCore!
 * @default none
 * 
 * @param OptionsKey:str
 * @text Options Key
 * @parent Shortcuts
 * @type combo
 * @option none
 * @option tab
 * @option shift
 * @option control
 * @option pageup
 * @option pagedown
 * @desc This is the key used for opening options.
 * Requires VisuMZ_1_OptionsCore!
 * @default none
 * 
 * @param GameEndKey:str
 * @text Game End Key
 * @parent Shortcuts
 * @type combo
 * @option none
 * @option tab
 * @option shift
 * @option control
 * @option pageup
 * @option pagedown
 * @desc This is the key used for ending the game.
 * @default none
 *
 * @param Vocab
 * @text Vocabulary
 *
 * @param Auto:str
 * @text Auto-Forward
 * @parent Vocab
 * @desc How is this option's text displayed in-game?
 * @default AUTO
 *
 * @param FastFwd:str
 * @text Fast Forward
 * @parent Vocab
 * @desc How is this option's text displayed in-game?
 * @default FAST
 *
 * @param Save:str
 * @text Save Game
 * @parent Vocab
 * @desc How is this option's text displayed in-game?
 * Requires VisuMZ_1_SaveCore!
 * @default SAVE
 *
 * @param Load:str
 * @text Load Game
 * @parent Vocab
 * @desc How is this option's text displayed in-game?
 * Requires VisuMZ_1_SaveCore!
 * @default LOAD
 *
 * @param Options:str
 * @text Options
 * @parent Vocab
 * @desc How is this option's text displayed in-game?
 * Requires VisuMZ_1_OptionsCore!
 * @default CONFIG
 *
 * @param GameEnd:str
 * @text Game End
 * @parent Vocab
 * @desc How is this option's text displayed in-game?
 * @default TITLE
 *
 */
/* ----------------------------------------------------------------------------
 * Message Cursor Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~MsgCursor:
 *
 * @param General
 *
 * @param Enable:eval
 * @text Enable?
 * @parent General
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Enable or disable the message cursor?
 * @default true
 *
 * @param GraphicType:str
 * @text Graphic Type
 * @parent General
 * @type select
 * @option Icon - From img/system/IconSet.png
 * @value icon
 * @option Image - An animated image from img/system/
 * @value image
 * @option Window Skin - Use the default Window Skin cursor
 * @value windowskin
 * @desc What is the cursor's graphic type?
 * @default icon
 * 
 * @param Icon
 *
 * @param IconIndex:str
 * @text Icon Index
 * @parent Icon
 * @desc This is icon used for the Message Cursor.
 * @default 188
 *
 * @param FlipMultiplier:str
 * @text Flip Speed Multiplier
 * @parent Icon
 * @desc What is the flip speed multiplier for the Message Cursor?
 * Use 0 for no flipping.
 * @default 1
 * 
 * @param Image
 *
 * @param Filename:str
 * @text Filename
 * @parent Image
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Filename of the image found inside the img/system/ folder.
 * @default 
 *
 * @param Rows:num
 * @text Image Rows
 * @parent Image
 * @type number
 * @min 1
 * @desc How many rows are there for the image?
 * @default 1
 *
 * @param Cols:num
 * @text Image Columns
 * @parent Image
 * @type number
 * @min 1
 * @desc How many columns are there for the image?
 * @default 1
 *
 * @param FrameDelay:num
 * @text Frame Delay
 * @parent Image
 * @type number
 * @min 1
 * @desc How many frames delayed are there per animated cell?
 * @default 4
 * 
 * @param Appearance
 *
 * @param AnchorX:num
 * @text Anchor X
 * @parent Appearance
 * @desc Determine the Message Cursor's X position.
 * Use a number between 0 and 1 for best results.
 * @default 0.5
 *
 * @param AnchorY:num
 * @text Anchor Y
 * @parent Appearance
 * @desc Determine the Message Cursor's Y position.
 * Use a number between 0 and 1 for best results.
 * @default 1
 *
 * @param OffsetX:num
 * @text Offset X
 * @parent Appearance
 * @desc Offset the Message Cursor's X position by how many pixels?
 * @default +0
 *
 * @param OffsetY:num
 * @text Offset Y
 * @parent Appearance
 * @desc Offset the Message Cursor's Y position by how many pixels?
 * @default -8
 *
 */
/* ----------------------------------------------------------------------------
 * Message Tail Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~MsgTail:
 *
 * @param AutoPosition
 * @text Auto-Position
 *
 * @param autoPositionTail:eval
 * @text Enable?
 * @parent AutoPosition
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Show Message Tails with Auto-Position text codes?
 * @default true
 *
 * @param autoPositionLeft:eval
 * @text Face Left?
 * @parent AutoPosition
 * @type boolean
 * @on Face Left
 * @off Face Right
 * @desc Which direction does the Message Tail point to?
 * @default true
 *
 * @param autoCorrectX:eval
 * @text Auto-Correct X
 * @parent AutoPosition
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Auto-corrects Message Tail position X when used with
 * Auto-Position but are too close to edge of screen.
 * @default true
 *
 * @param autoPositionOffsetX:num
 * @text Offset X
 * @parent AutoPosition
 * @desc Message Window's X offset with auto-position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param autoPositionOffsetY:num
 * @text Offset Y
 * @parent AutoPosition
 * @desc Message Window's Y offset with auto-position.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @param TailDir
 * @text Tail Directions
 *
 * @param BottomLeft
 * @text Bottom Left
 * @parent TailDir
 *
 * @param bottomLeftFilename:str
 * @text Filename
 * @parent BottomLeft
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Filename of the Message Tail graphic going towards
 * the bottom left.
 * @default 
 *
 * @param bottomLeftAnchorX:num
 * @text Anchor X
 * @parent BottomLeft
 * @desc Anchor value X. Use a number between 0 and 1.
 * 0.0 - Left; 0.5 - Center; 1.0 - Right
 * @default 0.5
 *
 * @param bottomLeftAnchorY:num
 * @text Anchor Y
 * @parent BottomLeft
 * @desc Anchor value Y. Use a number between 0 and 1.
 * 0.0 - Top; 0.5 - Middle; 1.0 - Bottom
 * @default 0.0
 *
 * @param bottomLeftOffsetX:num
 * @text Offset X
 * @parent BottomLeft
 * @desc Offset the Message Tail's X position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param bottomLeftOffsetY:num
 * @text Offset Y
 * @parent BottomLeft
 * @desc Offset the Message Tail's Y position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param BottomRight
 * @text Bottom Right
 * @parent TailDir
 *
 * @param bottomRightFilename:str
 * @text Filename
 * @parent BottomRight
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Filename of the Message Tail graphic going towards
 * the bottom right.
 * @default 
 *
 * @param bottomRightAnchorX:num
 * @text Anchor X
 * @parent BottomRight
 * @desc Anchor value X. Use a number between 0 and 1.
 * 0.0 - Left; 0.5 - Center; 1.0 - Right
 * @default 0.5
 *
 * @param bottomRightAnchorY:num
 * @text Anchor Y
 * @parent BottomRight
 * @desc Anchor value Y. Use a number between 0 and 1.
 * 0.0 - Top; 0.5 - Middle; 1.0 - Bottom
 * @default 0.0
 *
 * @param bottomRightOffsetX:num
 * @text Offset X
 * @parent BottomRight
 * @desc Offset the Message Tail's X position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param bottomRightOffsetY:num
 * @text Offset Y
 * @parent BottomRight
 * @desc Offset the Message Tail's Y position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param UpperLeft
 * @text Upper Left
 * @parent TailDir
 *
 * @param upperLeftFilename:str
 * @text Filename
 * @parent UpperLeft
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Filename of the Message Tail graphic going towards
 * the upper left.
 * @default 
 *
 * @param upperLeftAnchorX:num
 * @text Anchor X
 * @parent UpperLeft
 * @desc Anchor value X. Use a number between 0 and 1.
 * 0.0 - Left; 0.5 - Center; 1.0 - Right
 * @default 0.5
 *
 * @param upperLeftAnchorY:num
 * @text Anchor Y
 * @parent UpperLeft
 * @desc Anchor value Y. Use a number between 0 and 1.
 * 0.0 - Top; 0.5 - Middle; 1.0 - Bottom
 * @default 1.0
 *
 * @param upperLeftOffsetX:num
 * @text Offset X
 * @parent UpperLeft
 * @desc Offset the Message Tail's X position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param upperLeftOffsetY:num
 * @text Offset Y
 * @parent UpperLeft
 * @desc Offset the Message Tail's Y position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param UpperRight
 * @text Upper Right
 * @parent TailDir
 *
 * @param upperRightFilename:str
 * @text Filename
 * @parent UpperRight
 * @type file
 * @dir img/system/
 * @require 1
 * @desc Filename of the Message Tail graphic going towards
 * the upper right.
 * @default 
 *
 * @param upperRightAnchorX:num
 * @text Anchor X
 * @parent UpperRight
 * @desc Anchor value X. Use a number between 0 and 1.
 * 0.0 - Left; 0.5 - Center; 1.0 - Right
 * @default 0.5
 *
 * @param upperRightAnchorY:num
 * @text Anchor Y
 * @parent UpperRight
 * @desc Anchor value Y. Use a number between 0 and 1.
 * 0.0 - Top; 0.5 - Middle; 1.0 - Bottom
 * @default 1.0
 *
 * @param upperRightOffsetX:num
 * @text Offset X
 * @parent UpperRight
 * @desc Offset the Message Tail's X position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param upperRightOffsetY:num
 * @text Offset Y
 * @parent UpperRight
 * @desc Offset the Message Tail's Y position.
 * Negative: left. Positive: right.
 * @default +0
 *
 */
//=============================================================================

const _0x5a46c1=_0x36f0;function _0x36f0(_0xf10d84,_0x55d710){const _0xb78357=_0xb783();return _0x36f0=function(_0x36f01a,_0x178e9b){_0x36f01a=_0x36f01a-0x1c4;let _0x465cb5=_0xb78357[_0x36f01a];return _0x465cb5;},_0x36f0(_0xf10d84,_0x55d710);}(function(_0x2181c3,_0x1dc24c){const _0x1a2c3d=_0x36f0,_0x5586e4=_0x2181c3();while(!![]){try{const _0x54b94d=-parseInt(_0x1a2c3d(0x2f7))/0x1+parseInt(_0x1a2c3d(0x238))/0x2*(-parseInt(_0x1a2c3d(0x2d0))/0x3)+-parseInt(_0x1a2c3d(0x331))/0x4+parseInt(_0x1a2c3d(0x281))/0x5*(parseInt(_0x1a2c3d(0x210))/0x6)+-parseInt(_0x1a2c3d(0x2c7))/0x7*(parseInt(_0x1a2c3d(0x2c9))/0x8)+parseInt(_0x1a2c3d(0x2cf))/0x9*(-parseInt(_0x1a2c3d(0x325))/0xa)+parseInt(_0x1a2c3d(0x23d))/0xb;if(_0x54b94d===_0x1dc24c)break;else _0x5586e4['push'](_0x5586e4['shift']());}catch(_0x522dc4){_0x5586e4['push'](_0x5586e4['shift']());}}}(_0xb783,0x68ca1));var label=_0x5a46c1(0x1ea),tier=tier||0x0,dependencies=[_0x5a46c1(0x1ce)],pluginData=$plugins[_0x5a46c1(0x2a7)](function(_0x4408d8){const _0x2ffd84=_0x5a46c1;return _0x4408d8[_0x2ffd84(0x280)]&&_0x4408d8[_0x2ffd84(0x203)][_0x2ffd84(0x29a)]('['+label+']');})[0x0];VisuMZ[label][_0x5a46c1(0x1f4)]=VisuMZ[label][_0x5a46c1(0x1f4)]||{},VisuMZ[_0x5a46c1(0x2df)]=function(_0x2ed4d2,_0x5419c7){const _0x446e21=_0x5a46c1;for(const _0x344f5a in _0x5419c7){if(_0x344f5a[_0x446e21(0x311)](/(.*):(.*)/i)){const _0xc7105=String(RegExp['$1']),_0x4809f7=String(RegExp['$2'])['toUpperCase']()[_0x446e21(0x2e4)]();let _0xb341d,_0x441ae9,_0x1c1bb8;switch(_0x4809f7){case'NUM':_0xb341d=_0x5419c7[_0x344f5a]!==''?Number(_0x5419c7[_0x344f5a]):0x0;break;case _0x446e21(0x31a):_0x441ae9=_0x5419c7[_0x344f5a]!==''?JSON['parse'](_0x5419c7[_0x344f5a]):[],_0xb341d=_0x441ae9[_0x446e21(0x312)](_0x386edb=>Number(_0x386edb));break;case _0x446e21(0x231):_0xb341d=_0x5419c7[_0x344f5a]!==''?eval(_0x5419c7[_0x344f5a]):null;break;case _0x446e21(0x207):_0x441ae9=_0x5419c7[_0x344f5a]!==''?JSON[_0x446e21(0x251)](_0x5419c7[_0x344f5a]):[],_0xb341d=_0x441ae9[_0x446e21(0x312)](_0x5a5435=>eval(_0x5a5435));break;case _0x446e21(0x1ff):_0xb341d=_0x5419c7[_0x344f5a]!==''?JSON[_0x446e21(0x251)](_0x5419c7[_0x344f5a]):'';break;case'ARRAYJSON':_0x441ae9=_0x5419c7[_0x344f5a]!==''?JSON['parse'](_0x5419c7[_0x344f5a]):[],_0xb341d=_0x441ae9['map'](_0x16abb8=>JSON[_0x446e21(0x251)](_0x16abb8));break;case _0x446e21(0x2cd):_0xb341d=_0x5419c7[_0x344f5a]!==''?new Function(JSON['parse'](_0x5419c7[_0x344f5a])):new Function(_0x446e21(0x2d4));break;case _0x446e21(0x308):_0x441ae9=_0x5419c7[_0x344f5a]!==''?JSON[_0x446e21(0x251)](_0x5419c7[_0x344f5a]):[],_0xb341d=_0x441ae9['map'](_0x5ad98d=>new Function(JSON[_0x446e21(0x251)](_0x5ad98d)));break;case'STR':_0xb341d=_0x5419c7[_0x344f5a]!==''?String(_0x5419c7[_0x344f5a]):'';break;case _0x446e21(0x334):_0x441ae9=_0x5419c7[_0x344f5a]!==''?JSON['parse'](_0x5419c7[_0x344f5a]):[],_0xb341d=_0x441ae9[_0x446e21(0x312)](_0x1e1eda=>String(_0x1e1eda));break;case'STRUCT':_0x1c1bb8=_0x5419c7[_0x344f5a]!==''?JSON['parse'](_0x5419c7[_0x344f5a]):{},_0xb341d=VisuMZ[_0x446e21(0x2df)]({},_0x1c1bb8);break;case'ARRAYSTRUCT':_0x441ae9=_0x5419c7[_0x344f5a]!==''?JSON[_0x446e21(0x251)](_0x5419c7[_0x344f5a]):[],_0xb341d=_0x441ae9['map'](_0x2c510e=>VisuMZ[_0x446e21(0x2df)]({},JSON['parse'](_0x2c510e)));break;default:continue;}_0x2ed4d2[_0xc7105]=_0xb341d;}}return _0x2ed4d2;},(_0x458940=>{const _0x4198c8=_0x5a46c1,_0x4115fa=_0x458940[_0x4198c8(0x240)];for(const _0x60a2bc of dependencies){if(!Imported[_0x60a2bc]){alert('%1\x20is\x20missing\x20a\x20required\x20plugin.\x0aPlease\x20install\x20%2\x20into\x20the\x20Plugin\x20Manager.'[_0x4198c8(0x31e)](_0x4115fa,_0x60a2bc)),SceneManager[_0x4198c8(0x1d2)]();break;}}const _0x57c26f=_0x458940[_0x4198c8(0x203)];if(_0x57c26f[_0x4198c8(0x311)](/\[Version[ ](.*?)\]/i)){const _0x4b219f=Number(RegExp['$1']);_0x4b219f!==VisuMZ[label]['version']&&(alert(_0x4198c8(0x2e6)[_0x4198c8(0x31e)](_0x4115fa,_0x4b219f)),SceneManager[_0x4198c8(0x1d2)]());}if(_0x57c26f[_0x4198c8(0x311)](/\[Tier[ ](\d+)\]/i)){const _0x5dac2e=Number(RegExp['$1']);_0x5dac2e<tier?(alert('%1\x20is\x20incorrectly\x20placed\x20on\x20the\x20plugin\x20list.\x0aIt\x20is\x20a\x20Tier\x20%2\x20plugin\x20placed\x20over\x20other\x20Tier\x20%3\x20plugins.\x0aPlease\x20reorder\x20the\x20plugin\x20list\x20from\x20smallest\x20to\x20largest\x20tier\x20numbers.'['format'](_0x4115fa,_0x5dac2e,tier)),SceneManager[_0x4198c8(0x1d2)]()):tier=Math[_0x4198c8(0x32e)](_0x5dac2e,tier);}VisuMZ[_0x4198c8(0x2df)](VisuMZ[label][_0x4198c8(0x1f4)],_0x458940[_0x4198c8(0x27b)]);})(pluginData),PluginManager[_0x5a46c1(0x305)](pluginData[_0x5a46c1(0x240)],_0x5a46c1(0x1db),_0x414ba3=>{const _0x6c7b8=_0x5a46c1;VisuMZ[_0x6c7b8(0x2df)](_0x414ba3,_0x414ba3);const _0x25c0d2=!_0x414ba3['Allow'];$gameSystem[_0x6c7b8(0x200)](_0x25c0d2);}),PluginManager[_0x5a46c1(0x305)](pluginData[_0x5a46c1(0x240)],_0x5a46c1(0x230),_0x1e1094=>{const _0x986196=_0x5a46c1;VisuMZ[_0x986196(0x2df)](_0x1e1094,_0x1e1094);const _0x38e196=_0x1e1094[_0x986196(0x1c9)];$gameSystem[_0x986196(0x2b9)](_0x38e196);}),PluginManager['registerCommand'](pluginData['name'],_0x5a46c1(0x30d),_0x10274a=>{const _0x33d241=_0x5a46c1;VisuMZ[_0x33d241(0x2df)](_0x10274a,_0x10274a);const _0x5a37f1=_0x10274a['MsgCursor'];$gameSystem[_0x33d241(0x2db)](_0x5a37f1);const _0x2ca04f=SceneManager['_scene'][_0x33d241(0x205)];_0x2ca04f&&(_0x2ca04f[_0x33d241(0x2c1)](),_0x2ca04f[_0x33d241(0x289)]());}),PluginManager[_0x5a46c1(0x305)](pluginData['name'],_0x5a46c1(0x206),_0x1dd355=>{const _0x385ad6=_0x5a46c1;VisuMZ[_0x385ad6(0x2df)](_0x1dd355,_0x1dd355),$gameSystem[_0x385ad6(0x2e8)](_0x1dd355[_0x385ad6(0x1f4)]);}),TextManager[_0x5a46c1(0x215)]=function(_0x4bff7f){const _0x4f850e=_0x5a46c1;if(Window_ButtonConsole[_0x4f850e(0x2e7)][_0x4bff7f])return Window_ButtonConsole[_0x4f850e(0x2e7)][_0x4bff7f];return _0x4bff7f[_0x4f850e(0x24c)]()[_0x4f850e(0x2e4)]();},ColorManager[_0x5a46c1(0x20a)]=function(_0x551854){const _0x40dab2=_0x5a46c1;return _0x551854=String(_0x551854),_0x551854[_0x40dab2(0x311)](/#(.*)/i)?_0x40dab2(0x243)[_0x40dab2(0x31e)](String(RegExp['$1'])):this[_0x40dab2(0x22c)](Number(_0x551854));},SceneManager[_0x5a46c1(0x233)]=function(){const _0x2d55f4=_0x5a46c1;return this[_0x2d55f4(0x1c5)]&&this['_scene'][_0x2d55f4(0x1e3)]===Scene_Battle;},SceneManager[_0x5a46c1(0x22d)]=function(){const _0x46cc71=_0x5a46c1;return this[_0x46cc71(0x1c5)]&&this[_0x46cc71(0x1c5)][_0x46cc71(0x1e3)]===Scene_Map;},VisuMZ['ExtMessageFunc'][_0x5a46c1(0x247)]=SceneManager[_0x5a46c1(0x2b6)],SceneManager[_0x5a46c1(0x2b6)]=function(_0x204b2e){const _0x54545e=_0x5a46c1;VisuMZ['ExtMessageFunc'][_0x54545e(0x247)][_0x54545e(0x1e6)](this,_0x204b2e),[Scene_SaveButtonConsole,Scene_Save,Scene_Load][_0x54545e(0x29a)](_0x204b2e)&&this[_0x54545e(0x2c0)]();},SceneManager[_0x5a46c1(0x2c0)]=function(){const _0x5444c6=_0x5a46c1;for(const _0x1c3da1 of $gameParty[_0x5444c6(0x1d4)]()){_0x1c3da1[_0x5444c6(0x27a)]()&&ImageManager[_0x5444c6(0x2a5)](_0x1c3da1[_0x5444c6(0x27a)]()),_0x1c3da1['characterName']()&&ImageManager[_0x5444c6(0x2a4)](_0x1c3da1[_0x5444c6(0x242)]()),_0x1c3da1[_0x5444c6(0x253)]()&&ImageManager['loadSvActor'](_0x1c3da1[_0x5444c6(0x253)]());}},Game_Temp[_0x5a46c1(0x256)][_0x5a46c1(0x28a)]=function(){return this['_messageAutoForwardMode'];},Game_Temp[_0x5a46c1(0x256)]['setMessageAutoForwardMode']=function(_0x5abe8f){const _0x38745a=_0x5a46c1;this[_0x38745a(0x26e)]=_0x5abe8f,$gameMessage['refreshButtonConsole']();},Game_Temp[_0x5a46c1(0x256)][_0x5a46c1(0x25d)]=function(){return this['_extendedFastForwardMode'];},Game_Temp[_0x5a46c1(0x256)][_0x5a46c1(0x32d)]=function(_0x2735d4){const _0x4c386a=_0x5a46c1;this[_0x4c386a(0x302)]=_0x2735d4,$gameMessage['refreshButtonConsole']();},VisuMZ[_0x5a46c1(0x1ea)]['Game_Temp_requestAnimation']=Game_Temp['prototype'][_0x5a46c1(0x1da)],Game_Temp[_0x5a46c1(0x256)][_0x5a46c1(0x1da)]=function(_0x4a847c,_0x19cc30,_0x267904){const _0x4f51d0=_0x5a46c1;if(this[_0x4f51d0(0x2c8)]())return;VisuMZ[_0x4f51d0(0x1ea)]['Game_Temp_requestAnimation'][_0x4f51d0(0x1e6)](this,_0x4a847c,_0x19cc30,_0x267904);},Game_Temp[_0x5a46c1(0x256)][_0x5a46c1(0x2c8)]=function(){const _0x1b052e=_0x5a46c1,_0x250d6b=SceneManager['_scene'];return _0x250d6b&&_0x250d6b[_0x1b052e(0x25d)]&&_0x250d6b['isExtendedFastForwardMode']();},VisuMZ['ExtMessageFunc'][_0x5a46c1(0x263)]=Game_System['prototype'][_0x5a46c1(0x31f)],Game_System[_0x5a46c1(0x256)][_0x5a46c1(0x31f)]=function(){const _0x42d98b=_0x5a46c1;VisuMZ['ExtMessageFunc']['Game_System_initialize'][_0x42d98b(0x1e6)](this),this[_0x42d98b(0x319)](),this['initExtendedFastForward'](),this['initMessageCursorSettings']();},Game_System[_0x5a46c1(0x256)]['initMessageButtonConsole']=function(){const _0x43a846=_0x5a46c1;this['_messageButtonConsoleVisible']=Window_ButtonConsole[_0x43a846(0x252)];},Game_System['prototype']['isMessageButtonConsoleVisible']=function(){const _0x5479a2=_0x5a46c1;return this[_0x5479a2(0x1ee)]===undefined&&this[_0x5479a2(0x319)](),this[_0x5479a2(0x1ee)];},Game_System[_0x5a46c1(0x256)][_0x5a46c1(0x2b9)]=function(_0x195920){const _0x5a0954=_0x5a46c1;this['_messageButtonConsoleVisible']===undefined&&this[_0x5a0954(0x319)](),this[_0x5a0954(0x1ee)]=_0x195920;},Game_System[_0x5a46c1(0x256)][_0x5a46c1(0x2eb)]=function(){const _0x35d3b9=_0x5a46c1;this[_0x35d3b9(0x2ab)]=![];},Game_System[_0x5a46c1(0x256)][_0x5a46c1(0x2de)]=function(){const _0xb46ff0=_0x5a46c1;return this[_0xb46ff0(0x2ab)]===undefined&&this[_0xb46ff0(0x2eb)](),this['_disallowFastForward'];},Game_System[_0x5a46c1(0x256)]['setExtendedFastForwardDisallowed']=function(_0x1cff08){const _0x229125=_0x5a46c1;this[_0x229125(0x2ab)]===undefined&&this[_0x229125(0x2eb)](),this[_0x229125(0x2ab)]=_0x1cff08;},Game_System[_0x5a46c1(0x256)][_0x5a46c1(0x288)]=function(){const _0x39a34e=_0x5a46c1;this[_0x39a34e(0x2ac)]=JsonEx[_0x39a34e(0x209)](VisuMZ[_0x39a34e(0x1ea)][_0x39a34e(0x1f4)][_0x39a34e(0x335)]);},Game_System[_0x5a46c1(0x256)][_0x5a46c1(0x282)]=function(){const _0x3c4bb4=_0x5a46c1;return this[_0x3c4bb4(0x2ac)]===undefined&&this[_0x3c4bb4(0x288)](),this[_0x3c4bb4(0x2ac)];},Game_System[_0x5a46c1(0x256)][_0x5a46c1(0x2db)]=function(_0x3032f1){const _0x5e4a85=_0x5a46c1;this[_0x5e4a85(0x2ac)]===undefined&&this[_0x5e4a85(0x288)](),this[_0x5e4a85(0x2ac)]=JsonEx[_0x5e4a85(0x209)](_0x3032f1);},Game_System[_0x5a46c1(0x256)]['getMessageTailSettings']=function(){const _0x4228b8=_0x5a46c1;if(this[_0x4228b8(0x213)]===undefined){const _0x3b10c5=VisuMZ['ExtMessageFunc'][_0x4228b8(0x1f4)][_0x4228b8(0x261)];this[_0x4228b8(0x213)]=JsonEx[_0x4228b8(0x209)](_0x3b10c5);}return this[_0x4228b8(0x213)];},Game_System['prototype']['setMessageTailSettings']=function(_0x49f6c9){const _0x2bc262=_0x5a46c1;this['_messageTailSettings']=JsonEx[_0x2bc262(0x209)](_0x49f6c9);},Game_Message[_0x5a46c1(0x256)][_0x5a46c1(0x1dd)]=function(){const _0x28f272=_0x5a46c1,_0x5e76aa=SceneManager[_0x28f272(0x1c5)];if(!_0x5e76aa)return;const _0x1a8dd2=_0x5e76aa[_0x28f272(0x205)];if(!_0x1a8dd2)return;_0x1a8dd2['refreshButtonConsole']();},VisuMZ['ExtMessageFunc']['Scene_Boot_loadSystemImages']=Scene_Boot[_0x5a46c1(0x256)][_0x5a46c1(0x1f2)],Scene_Boot[_0x5a46c1(0x256)][_0x5a46c1(0x1f2)]=function(){const _0x460ee6=_0x5a46c1;VisuMZ[_0x460ee6(0x1ea)][_0x460ee6(0x2f3)][_0x460ee6(0x1e6)](this),this['loadSystemImagesForExtMessageFunc']();},Scene_Boot[_0x5a46c1(0x256)][_0x5a46c1(0x265)]=function(){const _0x46a1e6=_0x5a46c1,_0x4eb6d0=VisuMZ[_0x46a1e6(0x1ea)][_0x46a1e6(0x1f4)][_0x46a1e6(0x230)],_0x2e2b21=[_0x46a1e6(0x31c),_0x46a1e6(0x2fe),'ImgToggled'];for(const _0x4d26cf of _0x2e2b21){_0x4eb6d0[_0x4d26cf]=_0x4eb6d0[_0x4d26cf]??'',_0x4eb6d0[_0x4d26cf]!==''&&ImageManager[_0x46a1e6(0x293)](_0x4eb6d0[_0x4d26cf]);}},Scene_Message['EXT_FAST_FORWARD_ENABLED']=VisuMZ['ExtMessageFunc'][_0x5a46c1(0x1f4)][_0x5a46c1(0x29f)]['Enable'],Scene_Message[_0x5a46c1(0x2c2)]=VisuMZ[_0x5a46c1(0x1ea)]['Settings'][_0x5a46c1(0x29f)]['Speed'],Scene_Message[_0x5a46c1(0x2f5)]=VisuMZ['ExtMessageFunc'][_0x5a46c1(0x1f4)][_0x5a46c1(0x29f)][_0x5a46c1(0x1dc)]??!![],VisuMZ[_0x5a46c1(0x1ea)][_0x5a46c1(0x1d0)]=Scene_Message[_0x5a46c1(0x256)][_0x5a46c1(0x1e8)],Scene_Message[_0x5a46c1(0x256)][_0x5a46c1(0x1e8)]=function(){const _0x46f3cf=_0x5a46c1;VisuMZ[_0x46f3cf(0x1ea)][_0x46f3cf(0x1d0)][_0x46f3cf(0x1e6)](this),Scene_Message[_0x46f3cf(0x2f5)]&&$gameTemp['setExtendedFastForwardMode'](![]);},Scene_Message['prototype'][_0x5a46c1(0x25d)]=function(){const _0x4a7593=_0x5a46c1;if(!Scene_Message[_0x4a7593(0x211)])return![];if($gameSystem[_0x4a7593(0x2de)]())return![];if(this['anyActiveMessageInputWindows']())return![];return this['isActivatedExtendedFastForwardMode']();},Scene_Message[_0x5a46c1(0x256)][_0x5a46c1(0x328)]=function(){const _0x3a28a5=_0x5a46c1;if(Imported[_0x3a28a5(0x286)]&&$gameMap['isFurnitureSystemMode']())return![];if(Imported[_0x3a28a5(0x301)]){if(SceneManager[_0x3a28a5(0x329)]())return![];if(SceneManager[_0x3a28a5(0x338)])return![];}if(!this[_0x3a28a5(0x202)]()){if(Input[_0x3a28a5(0x2d7)](VisuMZ[_0x3a28a5(0x1d5)]['Settings'][_0x3a28a5(0x1eb)]['FastForwardKey']))return!![];}return $gameTemp[_0x3a28a5(0x25d)]();},Scene_Message[_0x5a46c1(0x256)]['anyActiveMessageInputWindows']=function(){const _0x141933=_0x5a46c1;if(this[_0x141933(0x332)]&&this[_0x141933(0x332)][_0x141933(0x1de)])return!![];if(this[_0x141933(0x2a8)]&&this[_0x141933(0x2a8)][_0x141933(0x1de)])return!![];if(this[_0x141933(0x222)]&&this['_eventItemWindow'][_0x141933(0x1de)])return!![];return![];},Scene_Message[_0x5a46c1(0x256)][_0x5a46c1(0x214)]=function(){const _0x528de2=_0x5a46c1;return Input[_0x528de2(0x21f)](_0x528de2(0x23b))||TouchInput[_0x528de2(0x1f9)]()?($gameTemp[_0x528de2(0x32d)](![]),!![]):![];},VisuMZ[_0x5a46c1(0x1ea)][_0x5a46c1(0x296)]=Scene_Map['prototype'][_0x5a46c1(0x2fb)],Scene_Map[_0x5a46c1(0x256)][_0x5a46c1(0x2fb)]=function(){const _0x4e5097=_0x5a46c1;this[_0x4e5097(0x25d)]()?this[_0x4e5097(0x223)]():VisuMZ[_0x4e5097(0x1ea)]['Scene_Map_updateMainMultiply'][_0x4e5097(0x1e6)](this);},Scene_Map[_0x5a46c1(0x256)]['isExtendedFastForwardMode']=function(){const _0x66ee3d=_0x5a46c1;return Scene_Message[_0x66ee3d(0x256)][_0x66ee3d(0x25d)][_0x66ee3d(0x1e6)](this)&&$gameMap[_0x66ee3d(0x239)]();},Scene_Map[_0x5a46c1(0x256)][_0x5a46c1(0x223)]=function(){const _0x1b7821=_0x5a46c1;let _0x50c0c6=Scene_Message['EXT_FAST_FORWARD_LOOPS'];while(_0x50c0c6--&&$gameMap[_0x1b7821(0x239)]()&&!this[_0x1b7821(0x202)]()){this['updateFade'](),this[_0x1b7821(0x330)](),this[_0x1b7821(0x2d2)](),SceneManager[_0x1b7821(0x2dc)]();if(this[_0x1b7821(0x214)]())break;}};function Scene_SaveButtonConsole(){const _0x596dca=_0x5a46c1;this[_0x596dca(0x31f)](...arguments);}Scene_SaveButtonConsole[_0x5a46c1(0x256)]=Object['create'](Scene_Save[_0x5a46c1(0x256)]),Scene_SaveButtonConsole[_0x5a46c1(0x256)][_0x5a46c1(0x1e3)]=Scene_SaveButtonConsole,Scene_SaveButtonConsole[_0x5a46c1(0x256)][_0x5a46c1(0x2f4)]=function(){const _0x153e82=_0x5a46c1;this['_cachedIndex']=0x0;let _0x405111=$gameMap['_interpreter'];for(;;){if(_0x405111['_childInterpreter'])_0x405111=_0x405111[_0x153e82(0x283)];else{this[_0x153e82(0x2a1)]=_0x405111[_0x153e82(0x1ed)],_0x405111['_index']=_0x405111[_0x153e82(0x25e)];break;}}Scene_Save[_0x153e82(0x256)][_0x153e82(0x2f4)][_0x153e82(0x1e6)](this),_0x405111[_0x153e82(0x1ed)]=this[_0x153e82(0x2a1)];},Scene_SaveButtonConsole[_0x5a46c1(0x256)][_0x5a46c1(0x268)]=function(_0x448a46){const _0x4e839b=_0x5a46c1;return Scene_Save[_0x4e839b(0x256)]['getCustomBackgroundSettings'][_0x4e839b(0x1e6)](this,_0x4e839b(0x2f8));},VisuMZ['ExtMessageFunc'][_0x5a46c1(0x270)]=Game_Interpreter[_0x5a46c1(0x256)][_0x5a46c1(0x26f)],Game_Interpreter[_0x5a46c1(0x256)][_0x5a46c1(0x26f)]=function(_0x1cfd08){const _0x4caddb=_0x5a46c1;return this[_0x4caddb(0x25e)]=this[_0x4caddb(0x1ed)],VisuMZ[_0x4caddb(0x1ea)]['Game_Interpreter_command101'][_0x4caddb(0x1e6)](this,_0x1cfd08);},VisuMZ[_0x5a46c1(0x1ea)][_0x5a46c1(0x322)]=Scene_Battle[_0x5a46c1(0x256)][_0x5a46c1(0x2e0)],Scene_Battle['prototype'][_0x5a46c1(0x2e0)]=function(){const _0x2bf652=_0x5a46c1;VisuMZ['ExtMessageFunc']['Scene_Battle_update'][_0x2bf652(0x1e6)](this);if(this[_0x2bf652(0x25d)]())this['updateExtendedFastForwardMode']();},Scene_Battle[_0x5a46c1(0x256)][_0x5a46c1(0x25d)]=function(){const _0x58563c=_0x5a46c1;return![];return Scene_Message[_0x58563c(0x256)][_0x58563c(0x25d)][_0x58563c(0x1e6)](this)&&$gameTroop['isEventRunning']()&&!this[_0x58563c(0x284)];},Scene_Battle['prototype']['updateExtendedFastForwardMode']=function(){const _0x50d750=_0x5a46c1;this['_extFastForwardLooping']=!![];let _0x51de12=Scene_Message['EXT_FAST_FORWARD_LOOPS'];while(_0x51de12--&&$gameTroop['isEventRunning']()&&!this[_0x50d750(0x202)]()){this[_0x50d750(0x2e0)](),SceneManager[_0x50d750(0x2dc)]();if(this[_0x50d750(0x214)]())break;}this[_0x50d750(0x284)]=![];},VisuMZ[_0x5a46c1(0x1ea)][_0x5a46c1(0x300)]=WindowLayer[_0x5a46c1(0x256)][_0x5a46c1(0x2e0)],WindowLayer['prototype'][_0x5a46c1(0x2e0)]=function(){const _0x5358c5=_0x5a46c1;if(SceneManager[_0x5358c5(0x1c5)]['_extFastForwardLooping'])return;VisuMZ[_0x5358c5(0x1ea)][_0x5358c5(0x300)]['call'](this);},VisuMZ[_0x5a46c1(0x1ea)][_0x5a46c1(0x216)]=Window_Base[_0x5a46c1(0x256)][_0x5a46c1(0x2dd)],Window_Base[_0x5a46c1(0x256)][_0x5a46c1(0x2dd)]=function(_0x5c4391){const _0xd93ee6=_0x5a46c1;this[_0xd93ee6(0x1e3)][_0xd93ee6(0x240)]===_0xd93ee6(0x1d9)&&this[_0xd93ee6(0x1d3)](_0x5c4391),VisuMZ['ExtMessageFunc'][_0xd93ee6(0x216)][_0xd93ee6(0x1e6)](this,_0x5c4391),this[_0xd93ee6(0x1e3)][_0xd93ee6(0x240)]==='Window_Message'&&this[_0xd93ee6(0x1e1)](_0x5c4391);},VisuMZ[_0x5a46c1(0x1ea)][_0x5a46c1(0x1ec)]=Window_Message['prototype'][_0x5a46c1(0x31f)],Window_Message[_0x5a46c1(0x256)]['initialize']=function(_0x38aa7e){const _0x2d3a40=_0x5a46c1;VisuMZ[_0x2d3a40(0x1ea)][_0x2d3a40(0x1ec)]['call'](this,_0x38aa7e),this[_0x2d3a40(0x2b0)]();},VisuMZ[_0x5a46c1(0x1ea)]['Window_Message_update']=Window_Message[_0x5a46c1(0x256)][_0x5a46c1(0x2e0)],Window_Message[_0x5a46c1(0x256)]['update']=function(){const _0x42dee6=_0x5a46c1;VisuMZ['ExtMessageFunc']['Window_Message_update'][_0x42dee6(0x1e6)](this),this[_0x42dee6(0x27e)](),this[_0x42dee6(0x33d)]();},Window_Message[_0x5a46c1(0x256)][_0x5a46c1(0x27e)]=function(){const _0x356c51=_0x5a46c1;if(!this[_0x356c51(0x1c7)]())return;$gameTemp[_0x356c51(0x28a)]()&&$gameTemp[_0x356c51(0x269)](![]),$gameTemp[_0x356c51(0x25d)]()&&$gameTemp[_0x356c51(0x32d)](![]);},Window_Message[_0x5a46c1(0x256)]['meetExtMsgFuncResetRequirements']=function(){const _0x4e5b15=_0x5a46c1;if(SceneManager[_0x4e5b15(0x22d)]()&&$gameMap&&!$gameMap[_0x4e5b15(0x239)]())return!![];else{if(SceneManager[_0x4e5b15(0x233)]()&&!$gameMap[_0x4e5b15(0x239)]())return!![];}return![];},VisuMZ[_0x5a46c1(0x1ea)][_0x5a46c1(0x1f3)]=Window_Message['prototype'][_0x5a46c1(0x21f)],Window_Message['prototype'][_0x5a46c1(0x21f)]=function(){const _0x1a4f54=_0x5a46c1;if(SceneManager[_0x1a4f54(0x1c5)][_0x1a4f54(0x25d)]())return!![];else{if(Input[_0x1a4f54(0x21f)](Window_ButtonConsole['SHORTCUT_KEY']['auto']))return this[_0x1a4f54(0x28c)](),![];else{if(Input[_0x1a4f54(0x21f)](Window_ButtonConsole[_0x1a4f54(0x33c)][_0x1a4f54(0x23c)]))return this[_0x1a4f54(0x290)](_0x1a4f54(0x23c)),![];else{if(Input[_0x1a4f54(0x21f)](Window_ButtonConsole[_0x1a4f54(0x33c)]['load']))return this['processButtonShortcut']('load'),![];else{if(Input['isTriggered'](Window_ButtonConsole[_0x1a4f54(0x33c)][_0x1a4f54(0x21a)]))return this[_0x1a4f54(0x290)]('options'),![];else{if(Input[_0x1a4f54(0x21f)](Window_ButtonConsole['SHORTCUT_KEY'][_0x1a4f54(0x291)]))return this[_0x1a4f54(0x290)](_0x1a4f54(0x291)),![];else return this[_0x1a4f54(0x2f6)]&&$gameTemp[_0x1a4f54(0x28a)]()?this[_0x1a4f54(0x30f)]():VisuMZ[_0x1a4f54(0x1ea)][_0x1a4f54(0x1f3)][_0x1a4f54(0x1e6)](this);}}}}}},VisuMZ[_0x5a46c1(0x1ea)][_0x5a46c1(0x1f5)]=Window_Message['prototype'][_0x5a46c1(0x2b8)],Window_Message['prototype'][_0x5a46c1(0x2b8)]=function(_0x34dbb7){const _0x2678ae=_0x5a46c1;this[_0x2678ae(0x25c)](_0x34dbb7),this[_0x2678ae(0x21b)](),this[_0x2678ae(0x27f)](_0x34dbb7),VisuMZ['ExtMessageFunc'][_0x2678ae(0x1f5)][_0x2678ae(0x1e6)](this,_0x34dbb7),this[_0x2678ae(0x257)]=0x0;},Window_Message['prototype']['drawMessageFace']=function(){const _0x37ce07=_0x5a46c1,_0x2e40f4=ImageManager[_0x37ce07(0x2ff)]||0x90,_0x339510=$gameMessage[_0x37ce07(0x27a)](),_0x12a920=$gameMessage[_0x37ce07(0x2aa)](),_0x2a935e=$gameMessage[_0x37ce07(0x21c)]();let _0x220026=_0x2e40f4,_0x58f402=this[_0x37ce07(0x2e1)],_0x150287=_0x2a935e?this[_0x37ce07(0x1f0)]-_0x220026-0x4:0x4,_0xece9d=0x0;_0x58f402-=this['addedHeight'](),this[_0x37ce07(0x310)](_0x339510,_0x12a920,_0x150287,_0xece9d,_0x220026,_0x58f402);},Window_Message[_0x5a46c1(0x2b3)]=VisuMZ[_0x5a46c1(0x1ea)][_0x5a46c1(0x1f4)]['Auto']['WaitPerChar'],Window_Message[_0x5a46c1(0x1d8)]=VisuMZ[_0x5a46c1(0x1ea)][_0x5a46c1(0x1f4)][_0x5a46c1(0x255)][_0x5a46c1(0x248)],Window_Message['prototype'][_0x5a46c1(0x1d3)]=function(_0x9818ff){const _0x5195b2=_0x5a46c1;this['_autoForwardCount']=this['_autoForwardCount']||0x0,this['_autoForwardCount']=Math[_0x5195b2(0x32e)](this[_0x5195b2(0x257)],0x0);const _0x41bacd=(_0x9818ff[_0x5195b2(0x22e)]||'')['length'];this['_autoForwardCount']+=_0x41bacd*Window_Message[_0x5195b2(0x2b3)];},Window_Message['prototype'][_0x5a46c1(0x28c)]=function(){const _0x132ba0=_0x5a46c1;if(this[_0x132ba0(0x227)])return;if(!$gameSystem['isMessageButtonConsoleVisible']())return;let _0x3f954c=!$gameTemp[_0x132ba0(0x28a)]();$gameTemp[_0x132ba0(0x269)](_0x3f954c),_0x3f954c?this[_0x132ba0(0x234)]():SoundManager[_0x132ba0(0x317)]();},Window_Message[_0x5a46c1(0x256)][_0x5a46c1(0x30f)]=function(){const _0x5802f8=_0x5a46c1;return this['_autoForwardCount']=this[_0x5802f8(0x257)]||0x0,VisuMZ['ExtMessageFunc'][_0x5802f8(0x1f3)][_0x5802f8(0x1e6)](this)?(SoundManager[_0x5802f8(0x317)](),$gameTemp[_0x5802f8(0x269)](![]),!![]):this[_0x5802f8(0x257)]--<=0x0;},VisuMZ[_0x5a46c1(0x1ea)][_0x5a46c1(0x267)]=Window_Message[_0x5a46c1(0x256)][_0x5a46c1(0x27c)],Window_Message['prototype'][_0x5a46c1(0x27c)]=function(){const _0x1b82d0=_0x5a46c1;VisuMZ[_0x1b82d0(0x1ea)]['Window_Message_startPause'][_0x1b82d0(0x1e6)](this),this[_0x1b82d0(0x257)]=this[_0x1b82d0(0x257)]||0x0,this[_0x1b82d0(0x257)]=Math[_0x1b82d0(0x32e)](this[_0x1b82d0(0x257)],Window_Message[_0x1b82d0(0x1d8)]);},VisuMZ['ExtMessageFunc'][_0x5a46c1(0x25a)]=Window_Message['prototype']['initMembers'],Window_Message[_0x5a46c1(0x256)][_0x5a46c1(0x221)]=function(){const _0x1b3b64=_0x5a46c1;VisuMZ[_0x1b3b64(0x1ea)][_0x1b3b64(0x25a)][_0x1b3b64(0x1e6)](this),this[_0x1b3b64(0x318)]();},VisuMZ[_0x5a46c1(0x1ea)][_0x5a46c1(0x1cc)]=Window_Base[_0x5a46c1(0x256)][_0x5a46c1(0x323)],Window_Base[_0x5a46c1(0x256)][_0x5a46c1(0x323)]=function(_0x109a48){const _0x196669=_0x5a46c1;return _0x109a48=_0x109a48[_0x196669(0x254)](/<HIDE (?:BUTTON CONSOLE|CONSOLE|BUTTONS)>/gi,_0x196669(0x25f)),_0x109a48=VisuMZ['ExtMessageFunc']['Window_Base_preConvertEscapeCharacters'][_0x196669(0x1e6)](this,_0x109a48),_0x109a48;},Window_Message[_0x5a46c1(0x256)][_0x5a46c1(0x25c)]=function(_0x55fde6){const _0x5be616=_0x5a46c1;let _0x377a9d=_0x55fde6[_0x5be616(0x339)];this[_0x5be616(0x227)]=![],_0x377a9d=_0x377a9d['replace'](_0x5be616(0x25f),()=>{const _0x461ecd=_0x5be616;return this[_0x461ecd(0x227)]=!![],'';}),this[_0x5be616(0x1e5)](_0x377a9d)&&(this[_0x5be616(0x227)]=!![]),_0x55fde6[_0x5be616(0x339)]=_0x377a9d;};if(!Window_Message[_0x5a46c1(0x256)][_0x5a46c1(0x20b)]){let text='';text+=_0x5a46c1(0x299),text+='The\x20latest\x20version\x20is\x20required\x20to\x20use\x0a',text+=_0x5a46c1(0x2d6),alert(text),SceneManager[_0x5a46c1(0x1d2)]();}function _0xb783(){const _0x1a236c=['checkBackImageSprites','autoPositionOffsetX','isTriggered','log','initMembers','_eventItemWindow','updateExtendedFastForwardMode','updateMessageTailPosition','skip','Window_Message_addedHeight','_hideButtonConsole','backlog','visible','addButtonConsoleObject','Filename','textColor','isSceneMap','buffer','FontFace','MsgButtonConsole','EVAL','windowskin','isSceneBattle','playOkSound','_messageTailSprite','refresh','opacity','662MjxBwp','isEventRunning','convertVariableEscapeCharacters','escape','save','19919394HamtQT','TEXT_COLOR_NORMAL','_type','name','updateCustomMessageCursorPauseSignSprites','characterName','#%1','_pauseSignAnimationCount','FastForwardKey','removeExistingPauseSignSprites','SceneManager_push','MinimumWait','_cache_customMessageCursorFrameCount','createCustomMessageCursorPauseSignSprites','fastfwd','toUpperCase','changeTextColor','autoPositionLeft','isSaveEnabled','updatePadding','parse','DEFAULT_SHOW','battlerName','replace','Auto','prototype','_autoForwardCount','startWait','showButtonConsole','Window_Message_initMembers','LoadKey','prepareHideButtonConsoleTextCode','isExtendedFastForwardMode','_lastExtMsgFuncIndex','<HIDEBUTTONCONSOLE>','isCustomMessageCursorEnabled','MsgTail','Window_Message_updateAutoPosition','Game_System_initialize','left','loadSystemImagesForExtMessageFunc','updateIconMessageCursorPauseSignSprites','Window_Message_startPause','getCustomBackgroundSettings','setMessageAutoForwardMode','bitmap','toggleMessageWindowVisibility','AutoSizeHide','width','_messageAutoForwardMode','command101','Game_Interpreter_command101','drawText','upper','anchor','autoPositionTail','WindowSkin','resetFontSettings','isOpen','AnchorX','iconHeight','faceName','parameters','startPause','_messageTail','updateExtMsgFuncResetTimers','parseMessageTailTextCodes','status','13865qmhTCN','getMessageCursorSettings','_childInterpreter','_extFastForwardLooping','USE_BACK_IMAGE_SPRITES','VisuMZ_2_FurnitureSystem','ButtonHeight','initMessageCursorSettings','_refreshPauseSign','isMessageAutoForwardMode','textColorID','toggleAutoForward','fontSize','IconSet','clamp','processButtonShortcut','gameend','autoPositionOffsetY','loadSystem','%1AnchorX','floor','Scene_Map_updateMainMultiply','top','AutoKey','VisuMZ_1_MessageCore\x20is\x20out\x20of\x20date.\x0a','includes','updateAutoPosition','FONT_FACE','length','height','FastFwd','image','_cachedIndex','bottom%1Filename','_parentWindow','loadCharacter','loadFace','scale','filter','_numberInputWindow','addChildToBack','faceIndex','_disallowFastForward','_msgCursorSettings','toLowerCase','createContents','updatePauseSignHeightextMsgFunction','createMessageTailSprite','_currentAutoSize','round','AUTO_FORWARD_DELAY_PER_CHAR','BUTTON_OFFSET_X','BUTTON_WIDTH','push','updateImageMessageCursorPauseSignSprites','newPage','setMessageButtonConsoleVisible','create','bottom','Cols','SKIN','openness','Options','loadPartyGraphics','_createPauseSignSprites','EXT_FAST_FORWARD_LOOPS','BUTTON_ORDER','updateMessageTailVisibility','updateBackImageSpriteVisibility','isAnySubWindowActive','21294gwogHO','isSceneUsingExFastForward','392vrMgho','lastFile','_pauseSignSprite','alignButtonConsoleButtons','FUNC','correctAutoMessageTailOffsetX','1495611HhJZLB','5394nKFKvb','auto','updateMain','clear','return\x200','IconIndex','the\x20VisuMZ_2_ExtMessageFunc\x20plugin.','isPressed','_buttonConsoleButtons','itemPadding','Enable','setMessageCursorSettings','updateEffekseer','flushTextState','isExtendedFastForwardDisallowed','ConvertParams','update','innerHeight','FontSize','NormalColor','trim','Window_Message_clampPlacementPosition','%1\x27s\x20version\x20does\x20not\x20match\x20plugin\x27s.\x20Please\x20update\x20it\x20in\x20the\x20Plugin\x20Manager.','VOCAB','setMessageTailSettings','updateBackOpacity','GraphicType','initExtendedFastForward','isTouchScrollEnabled','alpha','_buttonConsoleSprites','direction','TEXT_COLOR_DISABLED','_updatePauseSign','show','Scene_Boot_loadSystemImages','onSavefileOk','EXT_FAST_FORWARD_STOP_ON_SCENE_CHANGE','pause','637083BuLLSL','Scene_Save','setupMessageTailSettings','ImgToggled','updateMainMultiply','BUTTON_OFFSET_Y','updateConsoleVisibility','ImgEnabled','standardFaceWidth','WindowLayer_update','VisuMZ_2_QTE_TriggerSys','_extendedFastForwardMode','clampPlacementPosition','center','registerCommand','Right','isMessageButtonConsoleVisible','ARRAYFUNC','convertMessageTailEscapeCodes','_contentsSprite','playBuzzerSound','cos','MessageCursorSettings','backOpacity','autoForwardTriggered','drawFace','match','map','%1Filename','frameCount','drawing','BUTTON_HEIGHT','playCancel','createButtonConsole','initMessageButtonConsole','ARRAYNUM','load','ImgDisabled','createBackImageSprites','format','initialize','Window_Message_autoPositionOffsetY','Save','Scene_Battle_update','preConvertEscapeCharacters','padding','20GaNqsV','location','getMessageTailMainKey','isActivatedExtendedFastForwardMode','isPlayingQTE','setFrame','EXT_CURSOR_FOLLOW_TEXT','usesAutoPositionMessageTail','setExtendedFastForwardMode','max','_autoSizeRegexp','updateColorFilter','1145516pgoKdx','_choiceListWindow','hide','ARRAYSTR','MsgCursor','updateMessageTailBitmap','TEXT_COLOR_TOGGLED','_afterQteSessionDelay','text','updateDimensions','DisabledColor','SHORTCUT_KEY','updateMessageTailSprite','VisuMZ_4_MessageVisibility','_scene','_autoPositionTarget','meetExtMsgFuncResetRequirements','isAnySavefileExists','Visible','_correctAutoMessageTailOffsetX','%1AnchorY','Window_Base_preConvertEscapeCharacters','FollowText','VisuMZ_1_MessageCore','positionX','Scene_Message_createAllWindows','GameEndKey','exit','addAutoForwardDelay','members','MessageCore','%1OffsetY','ButtonWidth','AUTO_FORWARD_MIN_DELAY','Window_Message','requestAnimation','ExtFastFwdDisallow','SceneChangeReset','refreshButtonConsole','active','Window_Message_updateDimensions','Window_Message_startWait','moveCustomMessageCursorPauseSign','loadWindowskin','constructor','addChild','hideButtonConsoleAutoSize','call','BUTTON_BUFFER','createAllWindows','iconWidth','ExtMessageFunc','General','Window_Message_initialize','_index','_messageButtonConsoleVisible','ButtonOffsetX','innerWidth','AnchorY','loadSystemImages','Window_Message_isTriggered','Settings','Window_Message_newPage','Left','FONT_SIZE','VisuMZ_3_MessageLog','isCancelled','getMessageTailSettings','Window_Message_autoPositionOffsetX','ButtonBuffer','Buttons','ButtonOffsetY','JSON','setExtendedFastForwardDisallowed','refreshCustomMessageCursorPauseSign','anyActiveMessageInputWindows','description','_heldDownFastFwd','_messageWindow','MessageTailSettings','ARRAYEVAL','%1OffsetX','makeDeepCopy','getColor','addedHeight','contents','OffsetY','isClosing','right','1338eBEIVh','EXT_FAST_FORWARD_ENABLED','FlipMultiplier','_messageTailSettings','updateExtendedFastForwardCancel','msgButtonConsole','Window_Base_flushTextState','isMainMenuMessageLogEnabled','FrameDelay','POSITION','options','resetMessageTailSettings','isRTL'];_0xb783=function(){return _0x1a236c;};return _0xb783();}Window_Message[_0x5a46c1(0x256)][_0x5a46c1(0x1e5)]=function(_0x56ea1b){const _0x3dc371=_0x5a46c1;if(!VisuMZ[_0x3dc371(0x1ea)]['Settings']['MsgButtonConsole'][_0x3dc371(0x26c)])return![];if(_0x56ea1b[_0x3dc371(0x311)](Window_Message[_0x3dc371(0x32f)]))return!![];if(_0x56ea1b['match'](Window_Message['_autoPosRegExp']))return!![];return![];},VisuMZ[_0x5a46c1(0x1ea)][_0x5a46c1(0x226)]=Window_Message[_0x5a46c1(0x256)][_0x5a46c1(0x20b)],Window_Message[_0x5a46c1(0x256)][_0x5a46c1(0x20b)]=function(){const _0x5c9171=_0x5a46c1;let _0x19b30d=VisuMZ[_0x5c9171(0x1ea)]['Window_Message_addedHeight'][_0x5c9171(0x1e6)](this);if(this['_hideButtonConsole'])return _0x19b30d;return SceneManager[_0x5c9171(0x22d)]()&&$gameSystem[_0x5c9171(0x307)]()&&(['top','bottom'][_0x5c9171(0x29a)](Window_ButtonConsole['POSITION'][_0x5c9171(0x2ad)]()[_0x5c9171(0x2e4)]())&&(_0x19b30d+=Window_ButtonConsole[_0x5c9171(0x316)])),_0x19b30d;},VisuMZ['ExtMessageFunc'][_0x5a46c1(0x1df)]=Window_Message[_0x5a46c1(0x256)][_0x5a46c1(0x33a)],Window_Message['prototype'][_0x5a46c1(0x33a)]=function(){const _0x5018fe=_0x5a46c1;VisuMZ[_0x5018fe(0x1ea)]['Window_Message_updateDimensions'][_0x5018fe(0x1e6)](this),this[_0x5018fe(0x259)](),this[_0x5018fe(0x1dd)]();},Window_Message[_0x5a46c1(0x256)]['showButtonConsole']=function(){const _0x3ca38c=_0x5a46c1;if(!SceneManager[_0x3ca38c(0x22d)]())return;for(const _0x1429f1 of this['_buttonConsoleButtons']){!this[_0x3ca38c(0x227)]&&$gameSystem[_0x3ca38c(0x307)]()?_0x1429f1[_0x3ca38c(0x2f2)]():_0x1429f1[_0x3ca38c(0x333)]();}this[_0x3ca38c(0x2cc)]();},Window_Message[_0x5a46c1(0x256)][_0x5a46c1(0x1dd)]=function(){const _0x2bb354=_0x5a46c1;for(const _0x43b04 of this['_buttonConsoleButtons']){_0x43b04[_0x2bb354(0x236)]();}},Window_Message[_0x5a46c1(0x256)][_0x5a46c1(0x318)]=function(){const _0x429d43=_0x5a46c1;this[_0x429d43(0x2d8)]=[];for(const _0x19e9d0 of Window_ButtonConsole[_0x429d43(0x2c3)]){this[_0x429d43(0x22a)](_0x19e9d0);}this[_0x429d43(0x2cc)]();},Window_Message['prototype'][_0x5a46c1(0x22a)]=function(_0x15c5b0){const _0x47455f=_0x5a46c1;_0x15c5b0=_0x15c5b0['toLowerCase']()[_0x47455f(0x2e4)]();switch(_0x15c5b0){case _0x47455f(0x225):if(!Scene_Message[_0x47455f(0x211)])return;break;case _0x47455f(0x21a):if(!Imported['VisuMZ_1_OptionsCore'])return;break;case _0x47455f(0x23c):case'load':if(!Imported['VisuMZ_1_SaveCore'])return;break;case _0x47455f(0x333):if(!Imported[_0x47455f(0x1c4)])return;break;case _0x47455f(0x228):case _0x47455f(0x220):if(!Imported[_0x47455f(0x1f8)])return;break;}const _0x5d01c1=new Window_ButtonConsole(_0x15c5b0,this);this[_0x47455f(0x2d8)][_0x47455f(0x2b6)](_0x5d01c1),this[_0x47455f(0x1e4)](_0x5d01c1);},Window_Message[_0x5a46c1(0x256)][_0x5a46c1(0x2cc)]=function(){const _0x1a1219=_0x5a46c1;if(!SceneManager[_0x1a1219(0x22d)]())return;const _0x456f55=Window_ButtonConsole[_0x1a1219(0x219)][_0x1a1219(0x2ad)]()[_0x1a1219(0x2e4)](),_0x22d756=this[_0x1a1219(0x2d8)];this[_0x1a1219(0x30a)]['x']=this[_0x1a1219(0x30a)]['y']=0x0;if(!$gameSystem[_0x1a1219(0x307)]())return;if([_0x1a1219(0x297),_0x1a1219(0x2bb)][_0x1a1219(0x29a)](_0x456f55)){let _0x5506de=_0x22d756[_0x1a1219(0x29d)]*Window_ButtonConsole[_0x1a1219(0x2b5)];_0x5506de+=(_0x22d756[_0x1a1219(0x29d)]-0x1)*Window_ButtonConsole[_0x1a1219(0x1e7)];let _0x4e83f1=Math[_0x1a1219(0x295)]((this['width']-_0x5506de)/0x2),_0x538bd0=_0x4e83f1;_0x538bd0+=Window_ButtonConsole[_0x1a1219(0x2b4)];for(const _0x5c282d of _0x22d756){_0x5c282d['x']=_0x538bd0,_0x538bd0+=Window_ButtonConsole[_0x1a1219(0x2b5)]+Window_ButtonConsole[_0x1a1219(0x1e7)];}}if(_0x456f55===_0x1a1219(0x297)){let _0x52fe2b=Window_ButtonConsole[_0x1a1219(0x1e7)];for(const _0x565ecb of _0x22d756){_0x565ecb['y']=_0x52fe2b;}if(this[_0x1a1219(0x227)])return;_0x52fe2b=Window_ButtonConsole['BUTTON_HEIGHT'],_0x52fe2b+=Window_ButtonConsole[_0x1a1219(0x2fc)],this['_contentsSprite']['y']=_0x52fe2b;};if(_0x456f55===_0x1a1219(0x2bb)){let _0x1afd35=this[_0x1a1219(0x29e)]-Window_ButtonConsole['BUTTON_HEIGHT'];_0x1afd35-=Window_ButtonConsole[_0x1a1219(0x1e7)],_0x1afd35+=Window_ButtonConsole[_0x1a1219(0x2fc)];for(const _0x50a1e3 of _0x22d756){_0x50a1e3['y']=_0x1afd35;}}},Window_Message[_0x5a46c1(0x256)][_0x5a46c1(0x290)]=function(_0x33c1f0){const _0xbe29cc=_0x5a46c1;if(this['_hideButtonConsole'])return;if(!$gameSystem[_0xbe29cc(0x307)]())return;_0x33c1f0=_0x33c1f0['toLowerCase']()[_0xbe29cc(0x2e4)]();switch(_0x33c1f0){case _0xbe29cc(0x23c):$gameSystem[_0xbe29cc(0x24f)]()&&SceneManager[_0xbe29cc(0x22d)]()?(this[_0xbe29cc(0x234)](),SceneManager[_0xbe29cc(0x2b6)](Scene_SaveButtonConsole)):this[_0xbe29cc(0x30b)]();break;case _0xbe29cc(0x31b):DataManager[_0xbe29cc(0x1c8)]()&&SceneManager[_0xbe29cc(0x22d)]()?(this[_0xbe29cc(0x234)](),SceneManager[_0xbe29cc(0x2b6)](Scene_Load)):this[_0xbe29cc(0x30b)]();break;case _0xbe29cc(0x21a):SceneManager['isSceneMap']()?(this[_0xbe29cc(0x234)](),SceneManager[_0xbe29cc(0x2b6)](Scene_Options)):this[_0xbe29cc(0x30b)]();break;case _0xbe29cc(0x291):SceneManager[_0xbe29cc(0x22d)]()?(this['playOkSound'](),SceneManager[_0xbe29cc(0x2b6)](Scene_GameEnd)):this[_0xbe29cc(0x30b)]();break;}},VisuMZ['ExtMessageFunc']['Window_Message_startWait']=Window_Message[_0x5a46c1(0x256)][_0x5a46c1(0x258)],Window_Message[_0x5a46c1(0x256)][_0x5a46c1(0x258)]=function(_0x80a058){const _0x26ea76=_0x5a46c1;if(SceneManager[_0x26ea76(0x1c5)][_0x26ea76(0x25d)]())return;VisuMZ['ExtMessageFunc'][_0x26ea76(0x1e0)]['call'](this,_0x80a058);},Window_Message[_0x5a46c1(0x256)]['isCustomMessageCursorEnabled']=function(){const _0x56fed4=_0x5a46c1,_0x2b1b45=$gameSystem[_0x56fed4(0x282)]();return _0x2b1b45[_0x56fed4(0x2da)];},Window_Message[_0x5a46c1(0x256)]['_createPauseSignSprites']=function(){const _0x53babb=_0x5a46c1;this[_0x53babb(0x260)]()?(this[_0x53babb(0x246)](),this[_0x53babb(0x24a)]()):Window_Base['prototype']['_createPauseSignSprites'][_0x53babb(0x1e6)](this);},Window_Message[_0x5a46c1(0x256)][_0x5a46c1(0x246)]=function(){const _0x42ffd7=_0x5a46c1;if(!this[_0x42ffd7(0x2cb)])return;this['removeChild'](this[_0x42ffd7(0x2cb)]);},Window_Message[_0x5a46c1(0x256)][_0x5a46c1(0x24a)]=function(){const _0xd829aa=_0x5a46c1,_0x13b089=$gameSystem[_0xd829aa(0x282)]();this['_pauseSignSprite']=new Sprite(),this[_0xd829aa(0x1e4)](this['_pauseSignSprite']),this['_pauseSignSprite'][_0xd829aa(0x273)]['x']=_0x13b089[_0xd829aa(0x278)],this['_pauseSignSprite']['anchor']['y']=_0x13b089[_0xd829aa(0x1f1)],this['_pauseSignAnimationCount']=0x0;},Window_Message['prototype'][_0x5a46c1(0x289)]=function(){const _0x28e571=_0x5a46c1;this['isCustomMessageCursorEnabled']()?this[_0x28e571(0x201)]():(Window_Base[_0x28e571(0x256)]['_refreshPauseSign'][_0x28e571(0x1e6)](this),this[_0x28e571(0x2af)]());},Window_Message['prototype']['refreshCustomMessageCursorPauseSign']=function(){const _0x5db076=_0x5a46c1,_0x589aed=this['_pauseSignSprite'];if(!_0x589aed)return;const _0x4a110e=$gameSystem[_0x5db076(0x282)](),_0x2e3b94=_0x4a110e[_0x5db076(0x2ea)][_0x5db076(0x2ad)]()[_0x5db076(0x2e4)]();if(_0x2e3b94==='image')_0x589aed[_0x5db076(0x26a)]=ImageManager[_0x5db076(0x293)](_0x4a110e[_0x5db076(0x22b)]);else{if(_0x2e3b94==='windowskin'){const _0x31bce3=0x90,_0x263982=0x60,_0x26c152=0x18;_0x589aed[_0x5db076(0x26a)]=this['_windowskin'],_0x589aed['setFrame'](_0x31bce3,_0x263982,_0x26c152,_0x26c152);}else _0x589aed['bitmap']=ImageManager['loadSystem'](_0x5db076(0x28e));}},Window_Message[_0x5a46c1(0x256)][_0x5a46c1(0x2af)]=function(){const _0x435dc0=_0x5a46c1,_0x53e7d5=this[_0x435dc0(0x2cb)];if(!_0x53e7d5)return;if(!$gameSystem['isMessageButtonConsoleVisible']())return;if(this[_0x435dc0(0x2b1)])return;_0x53e7d5['y']-=Window_ButtonConsole[_0x435dc0(0x316)];},Window_Message[_0x5a46c1(0x256)][_0x5a46c1(0x2f1)]=function(){const _0x147fd6=_0x5a46c1;this[_0x147fd6(0x260)]()?this[_0x147fd6(0x241)]():Window_Base['prototype'][_0x147fd6(0x2f1)][_0x147fd6(0x1e6)](this);},Window_Message['prototype']['updateCustomMessageCursorPauseSignSprites']=function(){const _0x2d667e=_0x5a46c1;if(this['_cache_customMessageCursorFrameCount']===Graphics[_0x2d667e(0x314)])return;this[_0x2d667e(0x249)]=Graphics[_0x2d667e(0x314)];const _0x3bf8d8=this['_pauseSignSprite'];if(!_0x3bf8d8)return;const _0x2856eb=_0x3bf8d8[_0x2d667e(0x26a)];if(_0x2856eb[_0x2d667e(0x26d)]<=0x0)return;const _0x2cc2f8=$gameSystem[_0x2d667e(0x282)](),_0xc8e278=_0x2cc2f8[_0x2d667e(0x2ea)]['toLowerCase']()['trim'](),_0x150ade=this[_0x2d667e(0x2c6)]()||this[_0x2d667e(0x20e)]();_0x3bf8d8['alpha']=_0x150ade?0x0:0x1;if(_0x3bf8d8[_0x2d667e(0x2ed)]<=0x0)return;const _0x59e644=_0x2cc2f8['Rows']*_0x2cc2f8[_0x2d667e(0x2bc)];this[_0x2d667e(0x244)]++;while(this['_pauseSignAnimationCount']>=_0x59e644*_0x2cc2f8['FrameDelay']){this[_0x2d667e(0x244)]-=_0x59e644*_0x2cc2f8[_0x2d667e(0x218)];}if(_0xc8e278===_0x2d667e(0x2a0))this[_0x2d667e(0x2b7)]();else _0xc8e278===_0x2d667e(0x232)?Window_Base[_0x2d667e(0x256)]['_updatePauseSign'][_0x2d667e(0x1e6)](this):this[_0x2d667e(0x266)]();},Window_Message['prototype']['updateImageMessageCursorPauseSignSprites']=function(){const _0x2bd832=_0x5a46c1,_0x4fd281=this['_pauseSignSprite'],_0x5da0b1=_0x4fd281['bitmap'],_0x58c15e=$gameSystem[_0x2bd832(0x282)](),_0x302f4a=Math[_0x2bd832(0x295)](this[_0x2bd832(0x244)]/_0x58c15e['FrameDelay']),_0x5f084f=Math['floor'](_0x5da0b1[_0x2bd832(0x26d)]/_0x58c15e[_0x2bd832(0x2bc)]),_0x2309df=Math[_0x2bd832(0x295)](_0x5da0b1[_0x2bd832(0x29e)]/_0x58c15e['Rows']),_0x36e731=_0x302f4a%_0x58c15e[_0x2bd832(0x2bc)]*_0x5f084f,_0x286c80=Math[_0x2bd832(0x295)](_0x302f4a/_0x58c15e[_0x2bd832(0x2bc)])*_0x2309df;_0x4fd281[_0x2bd832(0x32a)](_0x36e731,_0x286c80,_0x5f084f,_0x2309df),_0x4fd281[_0x2bd832(0x229)]=this[_0x2bd832(0x277)]();},Window_Message['prototype'][_0x5a46c1(0x266)]=function(){const _0x2f058c=_0x5a46c1,_0x168e61=this['_pauseSignSprite'],_0x42b2a3=$gameSystem[_0x2f058c(0x282)](),_0x324511=_0x42b2a3[_0x2f058c(0x2d5)],_0x55f381=ImageManager[_0x2f058c(0x1e9)],_0xdc2845=ImageManager[_0x2f058c(0x279)],_0x2614ac=_0x324511%0x10*_0x55f381,_0x3d0f00=Math['floor'](_0x324511/0x10)*_0xdc2845;_0x168e61[_0x2f058c(0x32a)](_0x2614ac,_0x3d0f00,_0x55f381,_0xdc2845),_0x168e61[_0x2f058c(0x229)]=this[_0x2f058c(0x277)]();if(_0x42b2a3[_0x2f058c(0x212)]===0x0)return;_0x168e61[_0x2f058c(0x2a6)]['x']=Math[_0x2f058c(0x30c)](Graphics[_0x2f058c(0x314)]*_0x42b2a3[_0x2f058c(0x212)]);},Window_Message[_0x5a46c1(0x32b)]=VisuMZ[_0x5a46c1(0x1ea)][_0x5a46c1(0x1f4)][_0x5a46c1(0x335)][_0x5a46c1(0x1cd)]??!![],Window_Message[_0x5a46c1(0x256)][_0x5a46c1(0x1e1)]=function(_0x207d42){const _0x12c739=_0x5a46c1;if(!_0x207d42)return;if(!_0x207d42[_0x12c739(0x315)])return;if(!this[_0x12c739(0x260)]())return;const _0x5eac1b=this[_0x12c739(0x2cb)];if(!_0x5eac1b)return;const _0x97bb42=$gameSystem[_0x12c739(0x282)]();_0x5eac1b['x']=_0x207d42['x']+this['padding']+_0x97bb42['OffsetX']+_0x5eac1b[_0x12c739(0x26d)]/0x2,_0x5eac1b['x']+=this[_0x12c739(0x30a)]['x'],_0x5eac1b['y']=_0x207d42['y']+this[_0x12c739(0x324)]+_0x207d42[_0x12c739(0x29e)]+_0x97bb42[_0x12c739(0x20d)],_0x5eac1b['y']+=this['_contentsSprite']['y'],_0x5eac1b['x']=Math[_0x12c739(0x2b2)](_0x5eac1b['x'][_0x12c739(0x28f)](this[_0x12c739(0x324)],this[_0x12c739(0x26d)])),_0x5eac1b['y']=Math['round'](_0x5eac1b['y']['clamp'](this['padding'],this[_0x12c739(0x29e)]-this[_0x12c739(0x324)]));},Window_Message['prototype'][_0x5a46c1(0x2b0)]=function(){const _0x175af7=_0x5a46c1;this['_messageTailSprite']=new Sprite(),this[_0x175af7(0x235)][_0x175af7(0x229)]=![],this['addChild'](this[_0x175af7(0x235)]);},Window_Message[_0x5a46c1(0x256)]['resetMessageTailSettings']=function(){const _0x48a0f4=_0x5a46c1;this[_0x48a0f4(0x27d)]={'visible':![],'lastFile':'','location':_0x48a0f4(0x2bb),'direction':_0x48a0f4(0x264),'positionX':'auto'};},Window_Message['prototype'][_0x5a46c1(0x27f)]=function(_0x4c82ac){const _0x2bca7d=_0x5a46c1;_0x4c82ac['text']=this[_0x2bca7d(0x23a)](_0x4c82ac['text']),_0x4c82ac[_0x2bca7d(0x339)]=this[_0x2bca7d(0x309)](_0x4c82ac[_0x2bca7d(0x339)]);},Window_Message[_0x5a46c1(0x256)][_0x5a46c1(0x309)]=function(_0xbc4014){const _0x734c34=_0x5a46c1;return _0xbc4014=_0xbc4014['replace'](/<TAIL (?:BL|BOTTOM LEFT|DL|DOWN LEFT):[ ](\d+)>/gi,(_0x90bfcf,_0x55d543)=>{const _0x2b3b30=_0x36f0;return this[_0x2b3b30(0x2f9)](!![],!![],_0x55d543),'';}),_0xbc4014=_0xbc4014[_0x734c34(0x254)](/<TAIL (?:BR|BOTTOM RIGHT|DL|DOWN RIGHT):[ ](\d+)>/gi,(_0x27a6bf,_0x4c639e)=>{return this['setupMessageTailSettings'](!![],![],_0x4c639e),'';}),_0xbc4014=_0xbc4014[_0x734c34(0x254)](/<TAIL (?:UL|UPPER LEFT|UP LEFT):[ ](\d+)>/gi,(_0x2e6a32,_0xf12e)=>{return this['setupMessageTailSettings'](![],!![],_0xf12e),'';}),_0xbc4014=_0xbc4014['replace'](/<TAIL (?:UR|UPPER RIGHT|UP RIGHT):[ ](\d+)>/gi,(_0x155af5,_0x2f7814)=>{return this['setupMessageTailSettings'](![],![],_0x2f7814),'';}),_0xbc4014;},Window_Message[_0x5a46c1(0x256)][_0x5a46c1(0x2f9)]=function(_0x39dff8,_0x2253ec,_0x278d5b){const _0x2e1413=_0x5a46c1;if(!this['_messageTail'])this[_0x2e1413(0x21b)]();this[_0x2e1413(0x27d)]['visible']=!![],this[_0x2e1413(0x27d)]['location']=_0x39dff8?_0x2e1413(0x2bb):_0x2e1413(0x272),this[_0x2e1413(0x27d)][_0x2e1413(0x2ef)]=_0x2253ec?'left':_0x2e1413(0x20f),this[_0x2e1413(0x27d)][_0x2e1413(0x1cf)]=Number(_0x278d5b);},VisuMZ[_0x5a46c1(0x1ea)][_0x5a46c1(0x262)]=Window_Message[_0x5a46c1(0x256)][_0x5a46c1(0x29b)],Window_Message[_0x5a46c1(0x256)][_0x5a46c1(0x29b)]=function(){const _0x16d34f=_0x5a46c1;VisuMZ[_0x16d34f(0x1ea)]['Window_Message_updateAutoPosition'][_0x16d34f(0x1e6)](this);if(!this[_0x16d34f(0x1c6)])return;if(!this[_0x16d34f(0x235)])return;if(!this['_messageTail'])return;if(this[_0x16d34f(0x32c)]()){const _0xef4961=$gameSystem[_0x16d34f(0x1fa)](),_0x5a3ae0=_0xef4961[_0x16d34f(0x24e)]?_0x16d34f(0x264):_0x16d34f(0x20f);this[_0x16d34f(0x27d)][_0x16d34f(0x229)]=!![],this[_0x16d34f(0x27d)]['lastFile']='',this[_0x16d34f(0x27d)][_0x16d34f(0x326)]='bottom',this['_messageTail'][_0x16d34f(0x2ef)]=_0x5a3ae0,this[_0x16d34f(0x27d)][_0x16d34f(0x1cf)]=_0x16d34f(0x2d1);}},Window_Message[_0x5a46c1(0x256)][_0x5a46c1(0x32c)]=function(){const _0x24ef75=_0x5a46c1,_0x458717=$gameSystem[_0x24ef75(0x1fa)]();if(!_0x458717)return![];if(!_0x458717[_0x24ef75(0x274)])return![];const _0x636681=_0x458717['autoPositionLeft']?_0x24ef75(0x1f6):_0x24ef75(0x306),_0x8c45c9=_0x24ef75(0x2a2)[_0x24ef75(0x31e)](_0x636681),_0x195ef9=_0x458717[_0x8c45c9]||'';return _0x195ef9[_0x24ef75(0x2e4)]()!=='';},VisuMZ['ExtMessageFunc'][_0x5a46c1(0x1fb)]=Window_Message[_0x5a46c1(0x256)][_0x5a46c1(0x21e)],Window_Message[_0x5a46c1(0x256)][_0x5a46c1(0x21e)]=function(){const _0x2238e6=_0x5a46c1;let _0x3c8f0c=VisuMZ[_0x2238e6(0x1ea)][_0x2238e6(0x1fb)][_0x2238e6(0x1e6)](this);const _0x3b3475=$gameSystem[_0x2238e6(0x1fa)]();return _0x3b3475&&_0x3b3475[_0x2238e6(0x274)]&&(_0x3c8f0c+=_0x3b3475[_0x2238e6(0x21e)]),_0x3c8f0c;},VisuMZ['ExtMessageFunc'][_0x5a46c1(0x320)]=Window_Message[_0x5a46c1(0x256)][_0x5a46c1(0x292)],Window_Message[_0x5a46c1(0x256)][_0x5a46c1(0x292)]=function(){const _0x7a4fbd=_0x5a46c1;let _0x2464a3=VisuMZ[_0x7a4fbd(0x1ea)][_0x7a4fbd(0x320)]['call'](this);const _0x1d7079=$gameSystem['getMessageTailSettings']();return _0x1d7079&&_0x1d7079['autoPositionTail']&&(_0x2464a3+=_0x1d7079[_0x7a4fbd(0x292)]),_0x2464a3;},Window_Message['prototype']['updateMessageTailSprite']=function(){const _0xf8f918=_0x5a46c1;if(!this[_0xf8f918(0x235)])return;if(!this[_0xf8f918(0x27d)])return;this['updateMessageTailBitmap'](),this[_0xf8f918(0x2c4)](),this[_0xf8f918(0x224)]();},Window_Message[_0x5a46c1(0x256)][_0x5a46c1(0x327)]=function(){const _0x24bf19=_0x5a46c1,_0x48f35f=this['_messageTail'],_0x35e64f=_0x48f35f['location']===_0x24bf19(0x272)?'upper':_0x24bf19(0x2bb),_0x170c3a=_0x48f35f[_0x24bf19(0x2ef)]===_0x24bf19(0x264)?_0x24bf19(0x1f6):_0x24bf19(0x306);return'%1%2'[_0x24bf19(0x31e)](_0x35e64f,_0x170c3a);},Window_Message['prototype'][_0x5a46c1(0x336)]=function(){const _0x15ec30=_0x5a46c1,_0x102594=this[_0x15ec30(0x235)],_0x343a12=this[_0x15ec30(0x27d)],_0x188802=$gameSystem['getMessageTailSettings'](),_0x1022a0=this[_0x15ec30(0x327)]();if(_0x343a12['lastFile']===_0x188802[_0x15ec30(0x313)[_0x15ec30(0x31e)](_0x1022a0)])return;const _0x3561c7=_0x188802[_0x15ec30(0x313)[_0x15ec30(0x31e)](_0x1022a0)];_0x343a12[_0x15ec30(0x2ca)]=_0x3561c7,_0x3561c7?_0x102594[_0x15ec30(0x26a)]=ImageManager[_0x15ec30(0x293)](_0x3561c7):_0x102594[_0x15ec30(0x26a)]=new Bitmap(0x1,0x1);},Window_Message[_0x5a46c1(0x256)][_0x5a46c1(0x2c4)]=function(){const _0x2384e2=_0x5a46c1,_0x59316d=this[_0x2384e2(0x235)],_0x28bd6f=this['_messageTail'];_0x59316d[_0x2384e2(0x229)]=_0x28bd6f[_0x2384e2(0x229)]&&this[_0x2384e2(0x2be)]===0xff;},Window_Message['prototype']['updateMessageTailPosition']=function(){const _0x5d2bd5=_0x5a46c1,_0x6236cb=this['_messageTailSprite'],_0x4cb2ea=this[_0x5d2bd5(0x27d)],_0x14f24b=$gameSystem['getMessageTailSettings'](),_0x334e6e=this['getMessageTailMainKey']();_0x6236cb[_0x5d2bd5(0x273)]['x']=_0x14f24b[_0x5d2bd5(0x294)[_0x5d2bd5(0x31e)](_0x334e6e)],_0x6236cb[_0x5d2bd5(0x273)]['y']=_0x14f24b[_0x5d2bd5(0x1cb)[_0x5d2bd5(0x31e)](_0x334e6e)],_0x4cb2ea[_0x5d2bd5(0x1cf)]===_0x5d2bd5(0x2d1)?(_0x6236cb['x']=Math[_0x5d2bd5(0x2b2)](this['width']/0x2),_0x6236cb['x']+=this['correctAutoMessageTailOffsetX']()):(_0x4cb2ea[_0x5d2bd5(0x1cf)]=Number(_0x4cb2ea[_0x5d2bd5(0x1cf)]),_0x6236cb['x']=Math[_0x5d2bd5(0x2b2)](_0x4cb2ea['positionX'])),_0x4cb2ea[_0x5d2bd5(0x326)]==='upper'?_0x6236cb['y']=0x0:_0x6236cb['y']=this[_0x5d2bd5(0x29e)],_0x6236cb['x']+=_0x14f24b['%1OffsetX'[_0x5d2bd5(0x31e)](_0x334e6e)],_0x6236cb['y']+=_0x14f24b['%1OffsetY'['format'](_0x334e6e)];},VisuMZ[_0x5a46c1(0x1ea)][_0x5a46c1(0x2e5)]=Window_Message[_0x5a46c1(0x256)]['clampPlacementPosition'],Window_Message[_0x5a46c1(0x256)][_0x5a46c1(0x303)]=function(_0x137467,_0x3b66d4){const _0x4ca4cd=_0x5a46c1;this[_0x4ca4cd(0x1ca)]=0x0;const _0xee9fd1=this['x'];VisuMZ[_0x4ca4cd(0x1ea)]['Window_Message_clampPlacementPosition'][_0x4ca4cd(0x1e6)](this,_0x137467,_0x3b66d4);const _0x1c78ef=this['x'];this[_0x4ca4cd(0x1ca)]=_0xee9fd1-_0x1c78ef;},Window_Message[_0x5a46c1(0x256)][_0x5a46c1(0x2ce)]=function(){const _0x2d711a=_0x5a46c1;return $gameSystem[_0x2d711a(0x1fa)]()['autoCorrectX']??!![]?this[_0x2d711a(0x1ca)]||0x0:0x0;};function Window_ButtonConsole(){const _0x55dd59=_0x5a46c1;this[_0x55dd59(0x31f)](...arguments);}Window_ButtonConsole['prototype']=Object[_0x5a46c1(0x2ba)](Window_Scrollable['prototype']),Window_ButtonConsole['prototype'][_0x5a46c1(0x1e3)]=Window_ButtonConsole,Window_ButtonConsole[_0x5a46c1(0x252)]=VisuMZ[_0x5a46c1(0x1ea)][_0x5a46c1(0x1f4)]['MsgButtonConsole']['ShowDefault'],Window_ButtonConsole[_0x5a46c1(0x219)]=VisuMZ[_0x5a46c1(0x1ea)][_0x5a46c1(0x1f4)][_0x5a46c1(0x230)]['Position'],Window_ButtonConsole[_0x5a46c1(0x2bd)]=VisuMZ[_0x5a46c1(0x1ea)][_0x5a46c1(0x1f4)][_0x5a46c1(0x230)][_0x5a46c1(0x275)],Window_ButtonConsole[_0x5a46c1(0x29c)]=VisuMZ[_0x5a46c1(0x1ea)][_0x5a46c1(0x1f4)][_0x5a46c1(0x230)][_0x5a46c1(0x22f)],Window_ButtonConsole['FONT_SIZE']=VisuMZ[_0x5a46c1(0x1ea)][_0x5a46c1(0x1f4)]['MsgButtonConsole'][_0x5a46c1(0x2e2)],Window_ButtonConsole[_0x5a46c1(0x23e)]=VisuMZ[_0x5a46c1(0x1ea)][_0x5a46c1(0x1f4)][_0x5a46c1(0x230)][_0x5a46c1(0x2e3)],Window_ButtonConsole['TEXT_COLOR_TOGGLED']=VisuMZ[_0x5a46c1(0x1ea)][_0x5a46c1(0x1f4)]['MsgButtonConsole']['ToggledColor'],Window_ButtonConsole[_0x5a46c1(0x2f0)]=VisuMZ['ExtMessageFunc']['Settings'][_0x5a46c1(0x230)][_0x5a46c1(0x33b)],Window_ButtonConsole[_0x5a46c1(0x2b4)]=VisuMZ[_0x5a46c1(0x1ea)][_0x5a46c1(0x1f4)][_0x5a46c1(0x230)][_0x5a46c1(0x1ef)]??0x0,Window_ButtonConsole[_0x5a46c1(0x2fc)]=VisuMZ[_0x5a46c1(0x1ea)][_0x5a46c1(0x1f4)]['MsgButtonConsole'][_0x5a46c1(0x1fe)]??0x0,Window_ButtonConsole[_0x5a46c1(0x2b5)]=VisuMZ[_0x5a46c1(0x1ea)][_0x5a46c1(0x1f4)][_0x5a46c1(0x230)][_0x5a46c1(0x1d7)],Window_ButtonConsole[_0x5a46c1(0x316)]=VisuMZ[_0x5a46c1(0x1ea)][_0x5a46c1(0x1f4)][_0x5a46c1(0x230)][_0x5a46c1(0x287)],Window_ButtonConsole[_0x5a46c1(0x1e7)]=VisuMZ[_0x5a46c1(0x1ea)][_0x5a46c1(0x1f4)]['MsgButtonConsole'][_0x5a46c1(0x1fc)],Window_ButtonConsole[_0x5a46c1(0x2c3)]=VisuMZ[_0x5a46c1(0x1ea)][_0x5a46c1(0x1f4)][_0x5a46c1(0x1fd)]['List'],Window_ButtonConsole[_0x5a46c1(0x2e7)]={'auto':VisuMZ['ExtMessageFunc'][_0x5a46c1(0x1f4)]['Buttons'][_0x5a46c1(0x255)],'fastfwd':VisuMZ[_0x5a46c1(0x1ea)]['Settings'][_0x5a46c1(0x1fd)][_0x5a46c1(0x29f)],'save':VisuMZ['ExtMessageFunc'][_0x5a46c1(0x1f4)]['Buttons'][_0x5a46c1(0x321)],'load':VisuMZ[_0x5a46c1(0x1ea)][_0x5a46c1(0x1f4)][_0x5a46c1(0x1fd)]['Load'],'options':VisuMZ['ExtMessageFunc'][_0x5a46c1(0x1f4)][_0x5a46c1(0x1fd)][_0x5a46c1(0x2bf)],'gameend':VisuMZ[_0x5a46c1(0x1ea)][_0x5a46c1(0x1f4)][_0x5a46c1(0x1fd)]['GameEnd']},Window_ButtonConsole[_0x5a46c1(0x33c)]={'auto':VisuMZ[_0x5a46c1(0x1ea)][_0x5a46c1(0x1f4)][_0x5a46c1(0x1fd)][_0x5a46c1(0x298)],'save':VisuMZ[_0x5a46c1(0x1ea)]['Settings'][_0x5a46c1(0x1fd)]['SaveKey'],'load':VisuMZ['ExtMessageFunc'][_0x5a46c1(0x1f4)][_0x5a46c1(0x1fd)][_0x5a46c1(0x25b)],'options':VisuMZ[_0x5a46c1(0x1ea)]['Settings'][_0x5a46c1(0x1fd)]['OptionsKey'],'gameend':VisuMZ[_0x5a46c1(0x1ea)][_0x5a46c1(0x1f4)][_0x5a46c1(0x1fd)][_0x5a46c1(0x1d1)]},Window_ButtonConsole['prototype'][_0x5a46c1(0x31f)]=function(_0x5b039e,_0x167ef5){const _0x3fa448=_0x5a46c1,_0x1b07fa=new Rectangle(0x0,0x0,Window_ButtonConsole[_0x3fa448(0x2b5)],Window_ButtonConsole[_0x3fa448(0x316)]);this[_0x3fa448(0x2a3)]=_0x167ef5,Window_Scrollable[_0x3fa448(0x256)][_0x3fa448(0x31f)][_0x3fa448(0x1e6)](this,_0x1b07fa),this['createBackImageSprites'](),this[_0x3fa448(0x23f)]=_0x5b039e[_0x3fa448(0x2ad)]()[_0x3fa448(0x2e4)](),this[_0x3fa448(0x236)](),this['hide']();},Window_ButtonConsole['prototype'][_0x5a46c1(0x2d9)]=function(){return 0x0;},Window_ButtonConsole['prototype'][_0x5a46c1(0x1e2)]=function(){const _0x209246=_0x5a46c1;this[_0x209246(0x232)]=ImageManager[_0x209246(0x293)](Window_ButtonConsole[_0x209246(0x2bd)]);},Window_ButtonConsole[_0x5a46c1(0x256)][_0x5a46c1(0x250)]=function(){const _0x4c003b=_0x5a46c1;this[_0x4c003b(0x324)]=0x0;},Window_ButtonConsole['prototype'][_0x5a46c1(0x2e9)]=function(){const _0x3e007f=_0x5a46c1;this[_0x3e007f(0x30e)]=0xff;},Window_ButtonConsole[_0x5a46c1(0x256)][_0x5a46c1(0x31d)]=function(){const _0x3ac382=_0x5a46c1;Window_ButtonConsole[_0x3ac382(0x285)]===undefined&&this[_0x3ac382(0x21d)]();if(!Window_ButtonConsole[_0x3ac382(0x285)])return;this[_0x3ac382(0x237)]=0x0;const _0x2f4c50=VisuMZ['ExtMessageFunc']['Settings'][_0x3ac382(0x230)],_0x594b68=[_0x3ac382(0x31c),'ImgEnabled',_0x3ac382(0x2fa)];this['_buttonConsoleSprites']={};for(const _0x2121f0 of _0x594b68){if(_0x2f4c50[_0x2121f0]!==''){const _0x106a58=ImageManager[_0x3ac382(0x293)](_0x2f4c50[_0x2121f0]);this['_buttonConsoleSprites'][_0x2121f0]=new Sprite(_0x106a58);const _0x29f7bc=this['_buttonConsoleSprites'][_0x2121f0];this[_0x3ac382(0x2a9)](_0x29f7bc),_0x29f7bc['x']=_0x2f4c50[_0x3ac382(0x208)['format'](_0x2121f0)]||0x0,_0x29f7bc['y']=_0x2f4c50[_0x3ac382(0x1d6)[_0x3ac382(0x31e)](_0x2121f0)]||0x0;}}this[_0x3ac382(0x2c5)]();},Window_ButtonConsole[_0x5a46c1(0x256)][_0x5a46c1(0x21d)]=function(){const _0x2a89de=_0x5a46c1;Window_ButtonConsole[_0x2a89de(0x285)]=![];const _0x4530f7=VisuMZ[_0x2a89de(0x1ea)][_0x2a89de(0x1f4)][_0x2a89de(0x230)],_0x42c040=['ImgDisabled',_0x2a89de(0x2fe),_0x2a89de(0x2fa)];for(const _0x171a0e of _0x42c040){if(_0x4530f7[_0x171a0e]!==''){Window_ButtonConsole[_0x2a89de(0x285)]=!![];break;}}},Window_ButtonConsole[_0x5a46c1(0x256)]['resetFontSettings']=function(){const _0xf6e0e4=_0x5a46c1;Window_Scrollable[_0xf6e0e4(0x256)]['resetFontSettings'][_0xf6e0e4(0x1e6)](this),this[_0xf6e0e4(0x20c)]['fontFace']=Window_ButtonConsole['FONT_FACE'],this[_0xf6e0e4(0x20c)][_0xf6e0e4(0x28d)]=Window_ButtonConsole[_0xf6e0e4(0x1f7)];},Window_ButtonConsole[_0x5a46c1(0x256)][_0x5a46c1(0x236)]=function(){const _0x5e3c21=_0x5a46c1;this[_0x5e3c21(0x2ae)](),this[_0x5e3c21(0x276)]();const _0x1fd66b=TextManager[_0x5e3c21(0x215)](this[_0x5e3c21(0x23f)]),_0x1d2577=this['textColorID']();this[_0x5e3c21(0x24d)](ColorManager[_0x5e3c21(0x20a)](_0x1d2577)),this[_0x5e3c21(0x271)](_0x1fd66b,0x0,0x0,this[_0x5e3c21(0x1f0)],_0x5e3c21(0x304));},Window_ButtonConsole[_0x5a46c1(0x256)][_0x5a46c1(0x28b)]=function(){const _0x4e648d=_0x5a46c1;switch(this[_0x4e648d(0x23f)]){case'auto':if($gameTemp[_0x4e648d(0x28a)]())return Window_ButtonConsole['TEXT_COLOR_TOGGLED'];break;case _0x4e648d(0x24b):const _0x34f977=SceneManager[_0x4e648d(0x1c5)];if($gameSystem[_0x4e648d(0x2de)]())return Window_ButtonConsole[_0x4e648d(0x2f0)];else{if(_0x34f977&&_0x34f977[_0x4e648d(0x328)]&&_0x34f977[_0x4e648d(0x328)]())return Window_ButtonConsole[_0x4e648d(0x337)];}break;case _0x4e648d(0x23c):if(!$gameSystem[_0x4e648d(0x24f)]()||!SceneManager[_0x4e648d(0x22d)]())return Window_ButtonConsole['TEXT_COLOR_DISABLED'];break;case _0x4e648d(0x31b):if(!DataManager[_0x4e648d(0x1c8)]()||!SceneManager[_0x4e648d(0x22d)]())return Window_ButtonConsole['TEXT_COLOR_DISABLED'];break;case'options':case _0x4e648d(0x291):if(!SceneManager[_0x4e648d(0x22d)]())return Window_ButtonConsole[_0x4e648d(0x2f0)];break;case _0x4e648d(0x228):case _0x4e648d(0x220):if(!$gameSystem['isMainMenuMessageLogEnabled']()||!SceneManager[_0x4e648d(0x22d)]())return Window_ButtonConsole['TEXT_COLOR_DISABLED'];break;}return Window_ButtonConsole[_0x4e648d(0x23e)];},Window_ButtonConsole[_0x5a46c1(0x256)][_0x5a46c1(0x2ec)]=function(){return!![];},Window_ButtonConsole['prototype']['onTouchScrollStart']=function(){const _0x1ff757=_0x5a46c1;if(this['openness']<0xff)return;if(!this[_0x1ff757(0x229)])return;switch(this[_0x1ff757(0x23f)]){case'auto':let _0x43c588=!$gameTemp['isMessageAutoForwardMode']();$gameTemp[_0x1ff757(0x269)](_0x43c588);_0x43c588?this[_0x1ff757(0x234)]():SoundManager[_0x1ff757(0x317)]();break;case _0x1ff757(0x24b):if(!$gameSystem[_0x1ff757(0x2de)]()){let _0x30be75=!$gameTemp[_0x1ff757(0x25d)]();$gameTemp[_0x1ff757(0x32d)](_0x30be75),_0x30be75?this['playOkSound']():SoundManager['playCancel'](),this[_0x1ff757(0x236)]();}else this['playBuzzerSound']();break;case _0x1ff757(0x23c):$gameSystem[_0x1ff757(0x24f)]()&&SceneManager['isSceneMap']()?(this[_0x1ff757(0x234)](),SceneManager[_0x1ff757(0x2b6)](Scene_SaveButtonConsole)):this['playBuzzerSound']();break;case _0x1ff757(0x31b):DataManager[_0x1ff757(0x1c8)]()&&SceneManager[_0x1ff757(0x22d)]()?(this[_0x1ff757(0x234)](),SceneManager[_0x1ff757(0x2b6)](Scene_Load)):this['playBuzzerSound']();break;case _0x1ff757(0x21a):SceneManager[_0x1ff757(0x22d)]()?(this[_0x1ff757(0x234)](),SceneManager['push'](Scene_Options)):this[_0x1ff757(0x30b)]();break;case _0x1ff757(0x291):SceneManager['isSceneMap']()?(this[_0x1ff757(0x234)](),SceneManager[_0x1ff757(0x2b6)](Scene_GameEnd)):this['playBuzzerSound']();break;case'hide':Imported[_0x1ff757(0x1c4)]&&$gameTemp[_0x1ff757(0x26b)]();break;case _0x1ff757(0x228):case'log':Imported[_0x1ff757(0x1f8)]&&($gameSystem[_0x1ff757(0x217)]()&&SceneManager[_0x1ff757(0x22d)]()?(this[_0x1ff757(0x234)](),SceneManager[_0x1ff757(0x2b6)](Scene_MessageLog)):this[_0x1ff757(0x30b)]());break;}TouchInput[_0x1ff757(0x2d3)]();},Window_ButtonConsole[_0x5a46c1(0x256)]['update']=function(){const _0x2b4e23=_0x5a46c1;Window_Scrollable[_0x2b4e23(0x256)][_0x2b4e23(0x2e0)][_0x2b4e23(0x1e6)](this),this['updateConsoleVisibility'](),this['updateColor'](),this[_0x2b4e23(0x2c5)]();},Window_ButtonConsole['prototype'][_0x5a46c1(0x2fd)]=function(){const _0x16e886=_0x5a46c1;if(!this[_0x16e886(0x2a3)])return;this[_0x16e886(0x2be)]=this[_0x16e886(0x2a3)]['openness'];},Window_ButtonConsole[_0x5a46c1(0x256)]['updateColor']=function(){const _0x258c62=_0x5a46c1;this['_type']===_0x258c62(0x24b)&&(this[_0x258c62(0x204)]!==Input[_0x258c62(0x2d7)](VisuMZ[_0x258c62(0x1d5)]['Settings']['General'][_0x258c62(0x245)])&&(this[_0x258c62(0x204)]=Input['isPressed'](VisuMZ[_0x258c62(0x1d5)]['Settings'][_0x258c62(0x1eb)][_0x258c62(0x245)]),this[_0x258c62(0x236)]()));},Window_ButtonConsole[_0x5a46c1(0x256)][_0x5a46c1(0x2c5)]=function(){const _0x46353a=_0x5a46c1;if(!Window_ButtonConsole['USE_BACK_IMAGE_SPRITES'])return;if(this[_0x46353a(0x2ee)]['ImgDisabled']){const _0x27c49b=this[_0x46353a(0x2ee)]['ImgDisabled'];_0x27c49b[_0x46353a(0x229)]=this[_0x46353a(0x28b)]()===Window_ButtonConsole[_0x46353a(0x2f0)];}if(this[_0x46353a(0x2ee)][_0x46353a(0x2fe)]){const _0x2b6dff=this['_buttonConsoleSprites'][_0x46353a(0x2fe)];_0x2b6dff['visible']=this[_0x46353a(0x28b)]()===Window_ButtonConsole['TEXT_COLOR_NORMAL'];}if(this[_0x46353a(0x2ee)][_0x46353a(0x2fa)]){const _0x731ba2=this['_buttonConsoleSprites'][_0x46353a(0x2fa)];_0x731ba2['visible']=this[_0x46353a(0x28b)]()===Window_ButtonConsole[_0x46353a(0x337)];}};